/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.item;

import gdavid.phi.capability.MagazineSocketable;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.CADTakeEvent;
import vazkii.psi.api.cad.EnumCADComponent;
import vazkii.psi.api.cad.EnumCADStat;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.cad.ICADComponent;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.SpellRuntimeException;

@Mod.EventBusSubscriber
public class SpellMagazineItem
extends Item
implements ICADComponent {
    public static final String tagSlot = "slot";
    public static final String tagVector = "vector";
    public final String id;
    public int bandwidth;
    public int sockets;
    public int vectors;

    public SpellMagazineItem(String id, int sockets, int bandwidth, int vectors) {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f));
        this.setRegistryName(id);
        this.id = id;
        this.bandwidth = bandwidth;
        this.sockets = sockets;
        this.vectors = vectors;
    }

    public EnumCADComponent getComponentType(ItemStack stack) {
        return EnumCADComponent.SOCKET;
    }

    public int getCADStatValue(ItemStack stack, EnumCADStat stat) {
        if (stat == EnumCADStat.BANDWIDTH) {
            return this.bandwidth;
        }
        if (stat == EnumCADStat.SOCKETS) {
            return this.sockets;
        }
        if (stat == EnumCADStat.SAVED_VECTORS) {
            return this.vectors;
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack item, World world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        tooltip.add((ITextComponent)new TranslationTextComponent("item.phi." + this.id + ".desc"));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.phi.spell_magazine.desc"));
        tooltip.add((ITextComponent)new StringTextComponent(" ").func_230529_a_((ITextComponent)new TranslationTextComponent(EnumCADStat.BANDWIDTH.getName()).func_240699_a_(TextFormatting.AQUA)).func_240702_b_(": " + this.bandwidth));
        tooltip.add((ITextComponent)new StringTextComponent(" ").func_230529_a_((ITextComponent)new TranslationTextComponent(EnumCADStat.SOCKETS.getName()).func_240699_a_(TextFormatting.AQUA)).func_240702_b_(": " + this.sockets));
        tooltip.add((ITextComponent)new StringTextComponent(" ").func_230529_a_((ITextComponent)new TranslationTextComponent(EnumCADStat.SAVED_VECTORS.getName()).func_240699_a_(TextFormatting.AQUA)).func_240702_b_(": " + this.vectors));
    }

    public ICapabilityProvider initCapabilities(ItemStack item, CompoundNBT nbt) {
        return new MagazineSocketable(item, this.sockets);
    }

    @SubscribeEvent
    public static void TakeCAD(CADTakeEvent e) {
        ItemStack socket = e.getAssembler().getStackForComponent(EnumCADComponent.SOCKET);
        if (socket.func_77973_b() instanceof SpellMagazineItem) {
            ((SpellMagazineItem)socket.func_77973_b()).insertMag(socket, e.getCad());
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack item = player.func_184586_b(hand);
        ItemStack cad = PsiAPI.getPlayerCAD((PlayerEntity)player);
        ItemStack old = SpellMagazineItem.ejectMag(cad);
        if (old.func_190926_b()) {
            return ActionResult.func_226251_d_((Object)item);
        }
        if (!world.field_72995_K) {
            this.insertMag(item, cad);
        }
        return ActionResult.func_226249_b_((Object)old);
    }

    public static ItemStack ejectMag(ItemStack cad) {
        if (!(cad.func_77973_b() instanceof ICAD) || !ISocketable.isSocketable((ItemStack)cad)) {
            return ItemStack.field_190927_a;
        }
        ICAD cadItem = (ICAD)cad.func_77973_b();
        ItemStack socketStack = cadItem.getComponentInSlot(cad, EnumCADComponent.SOCKET).func_77946_l();
        if (!(socketStack.func_77973_b() instanceof SpellMagazineItem)) {
            return ItemStack.field_190927_a;
        }
        ((SpellMagazineItem)socketStack.func_77973_b()).fromCad(cad, socketStack);
        return socketStack;
    }

    public void fromCad(ItemStack cad, ItemStack mag) {
        int i;
        if (!(cad.func_77973_b() instanceof ICAD) || !ISocketable.isSocketable((ItemStack)cad)) {
            return;
        }
        ICAD cadItem = (ICAD)cad.func_77973_b();
        ISocketable socket = ISocketable.socketable((ItemStack)cad);
        ISocketable contents = ISocketable.socketable((ItemStack)mag);
        for (i = 0; i < this.sockets; ++i) {
            contents.setBulletInSocket(i, socket.getBulletInSocket(i));
        }
        for (i = 0; i < this.vectors; ++i) {
            try {
                this.setStoredVector(mag, i, cadItem.getStoredVector(cad, i));
                continue;
            }
            catch (SpellRuntimeException spellRuntimeException) {
                // empty catch block
            }
        }
    }

    public void insertMag(ItemStack mag, ItemStack cad) {
        int i;
        if (!(cad.func_77973_b() instanceof ICAD) || !ISocketable.isSocketable((ItemStack)cad)) {
            return;
        }
        ICAD cadItem = (ICAD)cad.func_77973_b();
        cadItem.setCADComponent(cad, mag);
        ISocketable socket = ISocketable.socketable((ItemStack)cad);
        ISocketable contents = ISocketable.socketable((ItemStack)mag);
        for (i = 0; i < this.sockets; ++i) {
            socket.setBulletInSocket(i, contents.getBulletInSocket(i));
        }
        for (i = 0; i < this.vectors; ++i) {
            try {
                cadItem.setStoredVector(cad, i, this.getStoredVector(mag, i));
                continue;
            }
            catch (SpellRuntimeException spellRuntimeException) {
                // empty catch block
            }
        }
        this.stripCadData(mag);
        cadItem.setCADComponent(cad, mag);
    }

    public void stripCadData(ItemStack item) {
        item.func_196083_e(tagVector);
        item.func_196083_e(tagSlot);
    }

    public Vector3 getStoredVector(ItemStack item, int slot) {
        CompoundNBT nbt = item.func_190925_c(tagVector);
        return new Vector3(nbt.func_74769_h(slot + "_x"), nbt.func_74769_h(slot + "_y"), nbt.func_74769_h(slot + "_z"));
    }

    public void setStoredVector(ItemStack item, int slot, Vector3 vec) {
        CompoundNBT nbt = item.func_190925_c(tagVector);
        nbt.func_74780_a(slot + "_x", vec.x);
        nbt.func_74780_a(slot + "_y", vec.y);
        nbt.func_74780_a(slot + "_z", vec.z);
    }
}

