/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.item;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.EnumCADComponent;
import vazkii.psi.api.cad.EnumCADStat;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.cad.ICADComponent;

@Mod.EventBusSubscriber
public class BloodConverterItem
extends Item
implements ICADComponent {
    public final String id;
    public float damageMultiplier;

    public BloodConverterItem(String id, float damageMultiplier) {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f));
        this.setRegistryName(id);
        this.id = id;
        this.damageMultiplier = damageMultiplier;
    }

    public EnumCADComponent getComponentType(ItemStack stack) {
        return EnumCADComponent.BATTERY;
    }

    public int getCADStatValue(ItemStack stack, EnumCADStat stat) {
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack item, World world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        tooltip.add((ITextComponent)new TranslationTextComponent("item.phi." + this.id + ".desc"));
        tooltip.add((ITextComponent)new StringTextComponent(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("phi.cadstat.overflow_damage").func_240699_a_(TextFormatting.AQUA)).func_240702_b_(": ").func_230529_a_((ITextComponent)new TranslationTextComponent("-" + 100.0f * (1.0f - this.damageMultiplier) + "%").func_240699_a_(TextFormatting.GREEN)));
    }

    @SubscribeEvent
    public static void overflowDamage(LivingHurtEvent event) {
        if (!event.getSource().func_76355_l().equals("psi-overload")) {
            return;
        }
        ItemStack item = PsiAPI.getPlayerCAD((PlayerEntity)((PlayerEntity)event.getEntity()));
        ICAD cad = (ICAD)item.func_77973_b();
        Item battery = cad.getComponentInSlot(item, EnumCADComponent.BATTERY).func_77973_b();
        if (battery instanceof BloodConverterItem) {
            event.setAmount(event.getAmount() * ((BloodConverterItem)battery).damageMultiplier);
        }
    }
}

