/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.entity.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import gdavid.phi.entity.PsionWaveEntity;
import gdavid.phi.util.RenderHelper;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PsionWaveRenderer
extends EntityRenderer<PsionWaveEntity> {
    static final RenderType layer = RenderType.func_228633_a_((String)"phi:psion_wave", (VertexFormat)DefaultVertexFormats.field_227852_q_, (int)7, (int)1440, (boolean)false, (boolean)false, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(new ResourceLocation("psi", "textures/particle/wisp.png"), false, false)).func_228714_a_(new RenderState.CullState(false)).func_228726_a_(new RenderState.TransparencyState("lightning_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    })).func_228727_a_(new RenderState.WriteMaskState(true, false)).func_228719_a_(new RenderState.LightmapState(true)).func_228728_a_(true));

    public PsionWaveRenderer(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public void render(PsionWaveEntity entity, float entityYaw, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffers, int light) {
        EntityDataManager dm = entity.func_184212_Q();
        ItemStack colorizer = (ItemStack)dm.func_187225_a(PsionWaveEntity.colorizer);
        int color = RenderHelper.getColorForColorizer(colorizer);
        int r = RenderHelper.r(color);
        int g = RenderHelper.g(color);
        int b = RenderHelper.b(color);
        IVertexBuilder buffer = buffers.getBuffer(layer);
        int fullbright = 0xF000F0;
        Quaternion rotation = Vector3f.field_229181_d_.func_229187_a_(entity.field_70177_z);
        rotation.func_195890_a(Vector3f.field_229178_a_.func_229187_a_(entity.field_70125_A));
        float traveledPercent = ((Float)dm.func_187225_a(PsionWaveEntity.traveled)).floatValue() / ((Float)dm.func_187225_a(PsionWaveEntity.distance)).floatValue();
        float size = 4.0f * traveledPercent * (1.0f - traveledPercent);
        size = (float)((double)size + Math.sin(((Float)dm.func_187225_a(PsionWaveEntity.frequency)).floatValue() * ((Float)dm.func_187225_a(PsionWaveEntity.traveled)).floatValue() / ((Float)dm.func_187225_a(PsionWaveEntity.speed)).floatValue()) * (double)size / 20.0);
        int particleCount = 90;
        for (float angle = 0.0f; angle < 360.0f; angle += 360.0f / (float)particleCount) {
            Vector3f pos = new Vector3f(0.0f, size / 2.0f, 0.0f);
            pos.func_214905_a(Vector3f.field_229182_e_.func_229187_a_(angle));
            pos.func_214905_a(rotation);
            pos.func_195904_b(0.0f, 0.5f, 0.0f);
            this.particle(buffer, ms, fullbright, r, g, b, pos, 0.05f);
        }
    }

    void particle(IVertexBuilder buffer, MatrixStack ms, int light, int r, int g, int b, Vector3f pos, float size) {
        float halfSize = size / 2.0f;
        ms.func_227860_a_();
        ms.func_227861_a_((double)pos.func_195899_a(), (double)pos.func_195900_b(), (double)pos.func_195902_c());
        ms.func_227863_a_(this.field_76990_c.func_229098_b_());
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        Matrix4f mat = ms.func_227866_c_().func_227870_a_();
        buffer.func_227888_a_(mat, -halfSize, halfSize, 0.0f).func_225586_a_(r, g, b, 255).func_225583_a_(0.0f, 1.0f).func_227886_a_(light).func_181675_d();
        buffer.func_227888_a_(mat, halfSize, halfSize, 0.0f).func_225586_a_(r, g, b, 255).func_225583_a_(1.0f, 1.0f).func_227886_a_(light).func_181675_d();
        buffer.func_227888_a_(mat, halfSize, -halfSize, 0.0f).func_225586_a_(r, g, b, 255).func_225583_a_(1.0f, 0.0f).func_227886_a_(light).func_181675_d();
        buffer.func_227888_a_(mat, -halfSize, -halfSize, 0.0f).func_225586_a_(r, g, b, 255).func_225583_a_(0.0f, 0.0f).func_227886_a_(light).func_181675_d();
        ms.func_227865_b_();
    }

    public ResourceLocation getEntityTexture(PsionWaveEntity entity) {
        return null;
    }
}

