/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.entity;

import gdavid.phi.block.tile.MPUTile;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.internal.IPlayerData;
import vazkii.psi.api.spell.ISpellImmune;

public class PsionWaveEntity
extends ThrowableEntity
implements ISpellImmune {
    public static final String id = "psion_wave";
    @ObjectHolder(value="phi:psion_wave")
    public static EntityType<PsionWaveEntity> type;
    static final String tagColorizer = "colorizer";
    static final String tagShooter = "shooter";
    static final String tagDirectionX = "direction_x";
    static final String tagDirectionY = "direction_y";
    static final String tagDirectionZ = "direction_z";
    static final String tagSpeed = "speed";
    static final String tagFrequency = "frequency";
    static final String tagDistance = "distance";
    static final String tagTraveled = "traveled";
    public static final DataParameter<ItemStack> colorizer;
    public static final DataParameter<Optional<UUID>> shooter;
    public static final DataParameter<Float> directionX;
    public static final DataParameter<Float> directionY;
    public static final DataParameter<Float> directionZ;
    public static final DataParameter<Float> speed;
    public static final DataParameter<Float> frequency;
    public static final DataParameter<Float> distance;
    public static final DataParameter<Float> traveled;

    public PsionWaveEntity(EntityType<PsionWaveEntity> type, World world) {
        super(type, world);
    }

    public PsionWaveEntity(World world, Vector3f direction, float speed, float frequency, float distance) {
        super(type, world);
        this.field_70180_af.func_187227_b(directionX, (Object)Float.valueOf(direction.func_195899_a()));
        this.field_70180_af.func_187227_b(directionY, (Object)Float.valueOf(direction.func_195900_b()));
        this.field_70180_af.func_187227_b(directionZ, (Object)Float.valueOf(direction.func_195902_c()));
        this.field_70180_af.func_187227_b(PsionWaveEntity.speed, (Object)Float.valueOf(speed));
        this.field_70180_af.func_187227_b(PsionWaveEntity.frequency, (Object)Float.valueOf(frequency));
        this.field_70180_af.func_187227_b(PsionWaveEntity.distance, (Object)Float.valueOf(distance));
    }

    public void func_212361_a(Entity entity) {
        super.func_212361_a(entity);
        this.field_70180_af.func_187227_b(shooter, Optional.of(entity.func_110124_au()));
    }

    public void setColorizer(ItemStack stack) {
        this.field_70180_af.func_187227_b(colorizer, (Object)stack);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(colorizer, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(shooter, Optional.of(new UUID(0L, 0L)));
        this.field_70180_af.func_187214_a(directionX, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(directionY, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(directionZ, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(speed, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(frequency, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(distance, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(traveled, (Object)Float.valueOf(0.0f));
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        ItemStack colorizerItem = (ItemStack)this.field_70180_af.func_187225_a(colorizer);
        if (!colorizerItem.func_190926_b()) {
            nbt.func_218657_a(tagColorizer, (INBT)colorizerItem.func_77955_b(new CompoundNBT()));
        }
        nbt.func_186854_a(tagShooter, (UUID)((Optional)this.field_70180_af.func_187225_a(shooter)).get());
        nbt.func_74776_a(tagDirectionX, ((Float)this.field_70180_af.func_187225_a(directionX)).floatValue());
        nbt.func_74776_a(tagDirectionY, ((Float)this.field_70180_af.func_187225_a(directionY)).floatValue());
        nbt.func_74776_a(tagDirectionZ, ((Float)this.field_70180_af.func_187225_a(directionZ)).floatValue());
        nbt.func_74776_a(tagSpeed, ((Float)this.field_70180_af.func_187225_a(speed)).floatValue());
        nbt.func_74776_a(tagFrequency, ((Float)this.field_70180_af.func_187225_a(frequency)).floatValue());
        nbt.func_74776_a(tagDistance, ((Float)this.field_70180_af.func_187225_a(distance)).floatValue());
        nbt.func_74776_a(tagTraveled, ((Float)this.field_70180_af.func_187225_a(traveled)).floatValue());
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.field_70180_af.func_187227_b(colorizer, (Object)ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l(tagColorizer)));
        this.field_70180_af.func_187227_b(shooter, Optional.of(nbt.func_186857_a(tagShooter)));
        this.field_70180_af.func_187227_b(directionX, (Object)Float.valueOf(nbt.func_74760_g(tagDirectionX)));
        this.field_70180_af.func_187227_b(directionY, (Object)Float.valueOf(nbt.func_74760_g(tagDirectionY)));
        this.field_70180_af.func_187227_b(directionZ, (Object)Float.valueOf(nbt.func_74760_g(tagDirectionZ)));
        this.field_70180_af.func_187227_b(speed, (Object)Float.valueOf(nbt.func_74760_g(tagSpeed)));
        this.field_70180_af.func_187227_b(frequency, (Object)Float.valueOf(nbt.func_74760_g(tagFrequency)));
        this.field_70180_af.func_187227_b(distance, (Object)Float.valueOf(nbt.func_74760_g(tagDistance)));
        this.field_70180_af.func_187227_b(traveled, (Object)Float.valueOf(nbt.func_74760_g(tagTraveled)));
    }

    public void func_70071_h_() {
        this.func_213293_j(((Float)this.field_70180_af.func_187225_a(directionX)).floatValue() * ((Float)this.field_70180_af.func_187225_a(speed)).floatValue() / 40.0f, ((Float)this.field_70180_af.func_187225_a(directionY)).floatValue() * ((Float)this.field_70180_af.func_187225_a(speed)).floatValue() / 40.0f, ((Float)this.field_70180_af.func_187225_a(directionZ)).floatValue() * ((Float)this.field_70180_af.func_187225_a(speed)).floatValue() / 40.0f);
        super.func_70071_h_();
        this.field_70180_af.func_187227_b(traveled, (Object)Float.valueOf(((Float)this.field_70180_af.func_187225_a(traveled)).floatValue() + ((Float)this.field_70180_af.func_187225_a(speed)).floatValue() / 40.0f));
        if (((Float)this.field_70180_af.func_187225_a(traveled)).floatValue() > ((Float)this.field_70180_af.func_187225_a(distance)).floatValue()) {
            this.func_70106_y();
        }
    }

    protected void func_70227_a(RayTraceResult result) {
        TileEntity tile;
        float traveledPercent = ((Float)this.field_70180_af.func_187225_a(traveled)).floatValue() / ((Float)this.field_70180_af.func_187225_a(distance)).floatValue();
        float focus = 2.0f * traveledPercent * (traveledPercent - 1.0f) + 1.0f;
        if (result instanceof EntityRayTraceResult) {
            Entity hit = ((EntityRayTraceResult)result).func_216348_a();
            if (hit.func_110124_au().equals(((Optional)this.field_70180_af.func_187225_a(shooter)).get()) && (double)((Float)this.field_70180_af.func_187225_a(traveled)).floatValue() < 0.8) {
                return;
            }
            if (hit instanceof PlayerEntity && !this.field_70170_p.field_72995_K) {
                PlayerEntity player = (PlayerEntity)hit;
                IPlayerData data = PsiAPI.internalHandler.getDataForPlayer(player);
                data.deductPsi((int)Math.ceil(((Float)this.field_70180_af.func_187225_a(frequency)).floatValue() * 10.0f * focus), (int)Math.ceil(((Float)this.field_70180_af.func_187225_a(frequency)).floatValue() * 2.0f * focus), true, true);
                EffectInstance effect = player.func_70660_b(Effects.field_76421_d);
                int newTime = effect == null ? (int)Math.ceil(((Float)this.field_70180_af.func_187225_a(frequency)).floatValue() * focus) : (int)Math.ceil(Math.pow(((Float)this.field_70180_af.func_187225_a(frequency)).floatValue() * focus + (float)effect.func_76459_b(), 1.0 + 0.2 * (double)focus));
                player.func_195064_c(new EffectInstance(Effects.field_76421_d, newTime % 600, newTime / 60, false, false));
            }
            this.func_70106_y();
        } else if (result instanceof BlockRayTraceResult && (tile = this.field_70170_p.func_175625_s(((BlockRayTraceResult)result).func_216350_a())) instanceof MPUTile) {
            ((MPUTile)tile).waveImpact((Float)this.field_70180_af.func_187225_a(frequency), focus);
            this.func_70106_y();
        }
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public boolean func_145773_az() {
        return true;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean isImmune() {
        return true;
    }

    static {
        colorizer = EntityDataManager.func_187226_a(PsionWaveEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
        shooter = EntityDataManager.func_187226_a(PsionWaveEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
        directionX = EntityDataManager.func_187226_a(PsionWaveEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
        directionY = EntityDataManager.func_187226_a(PsionWaveEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
        directionZ = EntityDataManager.func_187226_a(PsionWaveEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
        speed = EntityDataManager.func_187226_a(PsionWaveEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
        frequency = EntityDataManager.func_187226_a(PsionWaveEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
        distance = EntityDataManager.func_187226_a(PsionWaveEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
        traveled = EntityDataManager.func_187226_a(PsionWaveEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    }
}

