/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.capability;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.spell.ISpellAcceptor;

public class MagazineSocketable
implements ICapabilityProvider,
ISocketable {
    final ItemStack item;
    public int slots;

    public MagazineSocketable(ItemStack item, int slots) {
        this.item = item;
        this.slots = slots;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side) {
        if (capability == PsiAPI.SOCKETABLE_CAPABILITY) {
            return LazyOptional.of(() -> this).cast();
        }
        return LazyOptional.empty();
    }

    public boolean isSocketSlotAvailable(int slot) {
        return slot < this.slots;
    }

    public ItemStack getBulletInSocket(int slot) {
        CompoundNBT nbt = this.item.func_190925_c("slot").func_74775_l(Integer.toString(slot));
        if (nbt.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        return ItemStack.func_199557_a((CompoundNBT)nbt);
    }

    public void setBulletInSocket(int slot, ItemStack bullet) {
        CompoundNBT nbt = new CompoundNBT();
        if (!bullet.func_190926_b()) {
            bullet.func_77955_b(nbt);
        }
        this.item.func_190925_c("slot").func_218657_a(Integer.toString(slot), (INBT)nbt);
    }

    public int getSelectedSlot() {
        return 0;
    }

    public void setSelectedSlot(int slot) {
    }

    public int getLastSlot() {
        return this.slots - 1;
    }

    public boolean isItemValid(int slot, ItemStack bullet) {
        return this.isSocketSlotAvailable(slot) && ISpellAcceptor.isContainer((ItemStack)bullet);
    }
}

