/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.block.tile.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import gdavid.phi.block.MPUBlock;
import gdavid.phi.block.tile.MPUTile;
import gdavid.phi.util.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MPUTileRenderer
extends TileEntityRenderer<MPUTile> {
    public static final ResourceLocation psiBarTexture = new ResourceLocation("psi", "textures/gui/psi_bar.png");
    public static final int w = 174;
    public static final int h = 184;
    public static final int bw = 24;
    public static final int bh = 132;
    public static final int light = 0xF000F0;

    public MPUTileRenderer(TileEntityRendererDispatcher rendererDispatcher) {
        super(rendererDispatcher);
    }

    public void render(MPUTile mpu, float partialTicks, MatrixStack ms, IRenderTypeBuffer buf, int worldLight, int overlay) {
        ms.func_227860_a_();
        this.setupTransform(mpu, ms, 201, 184);
        this.drawSpell(mpu, ms, buf, 0xF000F0);
        ms.func_227860_a_();
        ms.func_227861_a_(177.0, 26.0, 0.0);
        this.drawPsiBar(mpu, ms, buf, 0xF000F0);
        ms.func_227865_b_();
        if (mpu.message != null) {
            ms.func_227860_a_();
            Minecraft.func_71410_x().field_71466_p.func_228079_a_(mpu.message.getString(), 0.0f, 184.0f, 0xFFFFFF, false, ms.func_227866_c_().func_227870_a_(), buf, false, 0, 0xF000F0);
            ms.func_227865_b_();
        }
        ms.func_227865_b_();
    }

    public void setupTransform(MPUTile mpu, MatrixStack ms, int width, int height) {
        ms.func_227861_a_(0.5, (double)1.62f, 0.5);
        ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(((Direction)mpu.func_195044_w().func_177229_b((Property)MPUBlock.field_185512_D)).func_185119_l()));
        ms.func_227861_a_(0.0, 0.0, 0.5);
        ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-60.0f));
        ms.func_227862_a_(0.0033333334f, 0.0033333334f, -0.0033333334f);
        ms.func_227861_a_((double)((float)(-width) / 2.0f), (double)((float)height / 2.0f), 0.0);
    }

    public void drawSpell(MPUTile mpu, MatrixStack ms, IRenderTypeBuffer buf, int light) {
        Minecraft mc = Minecraft.func_71410_x();
        try {
            IVertexBuilder buffer = buf.getBuffer((RenderType)Class.forName("vazkii.psi.client.gui.GuiProgrammer").getField("LAYER").get(null));
            Matrix4f mat = ms.func_227866_c_().func_227870_a_();
            buffer.func_227888_a_(mat, -7.0f, 177.0f, -0.01f).func_225586_a_(255, 255, 255, 128).func_225583_a_(0.0f, 0.71875f).func_227886_a_(light).func_181675_d();
            buffer.func_227888_a_(mat, 167.0f, 177.0f, -0.01f).func_225586_a_(255, 255, 255, 128).func_225583_a_(0.6796875f, 0.71875f).func_227886_a_(light).func_181675_d();
            buffer.func_227888_a_(mat, 167.0f, -7.0f, -0.01f).func_225586_a_(255, 255, 255, 128).func_225583_a_(0.6796875f, 0.0f).func_227886_a_(light).func_181675_d();
            buffer.func_227888_a_(mat, -7.0f, -7.0f, -0.01f).func_225586_a_(255, 255, 255, 128).func_225583_a_(0.0f, 0.0f).func_227886_a_(light).func_181675_d();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        mc.field_71466_p.func_228079_a_(I18n.func_135052_a((String)"psimisc.name", (Object[])new Object[0]), 0.0f, 164.0f, 0xFFFFFF, false, ms.func_227866_c_().func_227870_a_(), buf, false, 0, light);
        if (mpu.spell != null && !mpu.spell.grid.isEmpty()) {
            mpu.spell.draw(ms, buf, light);
            mc.field_71466_p.func_228079_a_(mpu.spell.name, 38.0f, 164.0f, 0xFFFFFF, false, ms.func_227866_c_().func_227870_a_(), buf, false, 0, light);
        }
    }

    public void drawPsiBar(MPUTile mpu, MatrixStack ms, IRenderTypeBuffer buf, int light) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(psiBarTexture);
        ms.func_227860_a_();
        ms.func_227861_a_(0.0, 0.0, (double)-0.01f);
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        AbstractGui.func_238463_a_((MatrixStack)ms, (int)0, (int)0, (float)4.0f, (float)6.0f, (int)24, (int)132, (int)64, (int)256);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ms.func_227865_b_();
        float percent = (float)mpu.psi / (float)mpu.getPsiCapacity();
        float percent2 = (float)mpu.prevPsi / (float)mpu.getPsiCapacity();
        int color = 1295871;
        int r = RenderHelper.r(color);
        int g = RenderHelper.g(color);
        int b = RenderHelper.b(color);
        Matrix4f mat = ms.func_227866_c_().func_227870_a_();
        BufferBuilder builder = Tessellator.func_178181_a().func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_227852_q_);
        builder.func_227888_a_(mat, 6.0f, 126.0f, 0.0f).func_225586_a_(r, g, b, 255).func_225583_a_(0.53125f, 0.4140625f).func_227886_a_(light).func_181675_d();
        builder.func_227888_a_(mat, 18.0f, 126.0f, 0.0f).func_225586_a_(r, g, b, 255).func_225583_a_(0.71875f, 0.4140625f).func_227886_a_(light).func_181675_d();
        builder.func_227888_a_(mat, 18.0f, 20.0f + (1.0f - percent) * 106.0f, 0.0f).func_225586_a_(r, g, b, 255).func_225583_a_(0.71875f, (1.0f - percent) * 106.0f / 256.0f).func_227886_a_(light).func_181675_d();
        builder.func_227888_a_(mat, 6.0f, 20.0f + (1.0f - percent) * 106.0f, 0.0f).func_225586_a_(r, g, b, 255).func_225583_a_(0.53125f, (1.0f - percent) * 106.0f / 256.0f).func_227886_a_(light).func_181675_d();
        builder.func_227888_a_(mat, 6.0f, 20.0f + (1.0f - percent) * 106.0f, 0.0f).func_225586_a_(r, g, b, 128).func_225583_a_(0.53125f, (1.0f - percent) * 106.0f / 256.0f).func_227886_a_(light).func_181675_d();
        builder.func_227888_a_(mat, 18.0f, 20.0f + (1.0f - percent) * 106.0f, 0.0f).func_225586_a_(r, g, b, 128).func_225583_a_(0.71875f, (1.0f - percent) * 106.0f / 256.0f).func_227886_a_(light).func_181675_d();
        builder.func_227888_a_(mat, 18.0f, 20.0f + (1.0f - percent2) * 106.0f, 0.0f).func_225586_a_(r, g, b, 128).func_225583_a_(0.71875f, (1.0f - percent2) * 106.0f / 256.0f).func_227886_a_(light).func_181675_d();
        builder.func_227888_a_(mat, 6.0f, 20.0f + (1.0f - percent2) * 106.0f, 0.0f).func_225586_a_(r, g, b, 128).func_225583_a_(0.53125f, (1.0f - percent2) * 106.0f / 256.0f).func_227886_a_(light).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }
}

