/*
 * Decompiled with CFR 0.152.
 */
package gdavid.phi.block.tile;

import com.mojang.authlib.GameProfile;
import gdavid.phi.block.MPUBlock;
import gdavid.phi.item.MPUCAD;
import gdavid.phi.spell.trick.evaluation.ReevaluateTrick;
import gdavid.phi.spell.trick.marker.MoveMarkerTrick;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.ref.WeakReference;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDirection;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import vazkii.psi.api.spell.EnumPieceType;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellPiece;

public class MPUTile
extends TileEntity
implements ITickableTileEntity {
    public static TileEntityType<MPUTile> type;
    public static final int complexityPerTick = 5;
    public static final ITextComponent statError;
    public static final String tagSpell = "spell";
    public static final String tagPsi = "psi";
    public static final String tagMessage = "message";
    public static final String tagComparatorSignal = "comparator_signal";
    public static final String tagSuccessCount = "success_count";
    public static final String tagCad = "cad";
    public Spell spell;
    public int psi;
    public ITextComponent message;
    public int comparatorSignal;
    public int successCount;
    public MPUCaster caster;
    public ItemStack cad = new ItemStack((IItemProvider)MPUCAD.instance);
    public WeakReference<SpellContext> context;
    public int castDelay;
    public int prevPsi;

    public MPUTile() {
        super(type);
    }

    public void setSpell(Spell to) {
        if (to == null) {
            this.spell = null;
        } else {
            this.spell = to.copy();
            this.spell.uuid = UUID.randomUUID();
        }
        this.message = null;
        this.successCount = 0;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 18);
    }

    public void addPsi(int amount) {
        if (amount == 0) {
            return;
        }
        this.psi = Math.max(0, Math.min(this.getPsiCapacity(), this.psi + amount));
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 18);
    }

    public int getPsiCapacity() {
        return 1000;
    }

    public void setTime(int time) {
        MPUCAD.instance.setTime(this.cad, time);
        this.func_70296_d();
    }

    public void waveImpact(Float frequency, float focus) {
        this.addPsi(-Math.round(frequency.floatValue() * focus * 4.0f));
        this.castDelay = Math.round(frequency.floatValue() * focus * 4.0f);
    }

    public void func_73660_a() {
        boolean recast;
        if (this.field_145850_b.field_72995_K) {
            this.prevPsi = this.psi < this.prevPsi ? Math.max(this.psi, this.prevPsi - 25) : this.psi;
            return;
        }
        MPUCAD.instance.incrementTime(this.cad);
        if (this.spell == null) {
            return;
        }
        if (this.caster == null) {
            this.caster = new MPUCaster();
        }
        this.caster.fix();
        if (this.castDelay > 0) {
            --this.castDelay;
            return;
        }
        boolean bl = recast = this.context == null || this.context.get() == null;
        if (!recast) {
            try {
                recast = !((Set)Class.forName("vazkii.psi.common.core.handler.PlayerDataHandler").getField("delayedContexts").get(null)).contains(this.context.get());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (recast) {
            if (this.field_145850_b.func_175640_z(this.func_174877_v())) {
                return;
            }
            SpellContext ctx = new SpellContext().setPlayer((PlayerEntity)this.caster).setSpell(this.spell);
            this.context = new WeakReference<SpellContext>(ctx);
            if (!ctx.isValid()) {
                return;
            }
            if (!ctx.cspell.metadata.evaluateAgainst(this.cad)) {
                if (this.message != statError) {
                    this.message = statError;
                    this.func_70296_d();
                    this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 18);
                }
                return;
            }
            int cost = ctx.cspell.metadata.getStat(EnumSpellStat.COST);
            if (cost == 0 && this.minCostFix(this.spell)) {
                cost = 1;
            }
            if (this.psi < cost) {
                return;
            }
            this.addPsi(-cost);
            this.castDelay = ctx.cspell.metadata.getStat(EnumSpellStat.COMPLEXITY) / 5;
            if (ctx.cspell.metadata.getFlag("phi:psi_transfer")) {
                this.castDelay = Math.max(this.castDelay, 4);
            }
            ctx.cspell.safeExecute(ctx);
            ++this.successCount;
            this.func_70296_d();
        }
    }

    public boolean minCostFix(Spell spell) {
        SpellPiece[][] spellPieceArray = spell.grid.gridData;
        int n = spellPieceArray.length;
        for (int i = 0; i < n; ++i) {
            SpellPiece[] pieces;
            for (SpellPiece piece : pieces = spellPieceArray[i]) {
                if (piece == null || piece.getPieceType() != EnumPieceType.TRICK) continue;
                try {
                    String name;
                    SpellMetadata meta = new SpellMetadata();
                    piece.addToMetadata(meta);
                    if (meta.getStat(EnumSpellStat.PROJECTION) == 0 || (name = piece.getClass().getName()).equals("vazkii.psi.common.spell.trick.PieceTrickParticleTrail") || name.equals("vazkii.psi.common.spell.trick.PieceTrickPlaySound") || piece instanceof MoveMarkerTrick || piece instanceof ReevaluateTrick) continue;
                    return true;
                }
                catch (SpellCompilationException spellCompilationException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.read(nbt);
    }

    public void read(CompoundNBT nbt) {
        if (this.spell == null) {
            this.spell = Spell.createFromNBT((CompoundNBT)nbt.func_74775_l(tagSpell));
        } else {
            this.spell.readFromNBT(nbt.func_74775_l(tagSpell));
        }
        this.psi = nbt.func_74762_e(tagPsi);
        MPUCAD.instance.getData(this.cad).deserializeNBT((INBT)nbt.func_74775_l(tagCad));
        this.message = ITextComponent.Serializer.func_240643_a_((String)nbt.func_74779_i(tagMessage));
        this.comparatorSignal = nbt.func_74762_e(tagComparatorSignal);
        this.successCount = nbt.func_74762_e(tagSuccessCount);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt = super.func_189515_b(nbt);
        CompoundNBT spellNbt = new CompoundNBT();
        if (this.spell != null) {
            this.spell.writeToNBT(spellNbt);
        }
        nbt.func_218657_a(tagSpell, (INBT)spellNbt);
        nbt.func_74768_a(tagPsi, this.psi);
        nbt.func_218657_a(tagCad, MPUCAD.instance.getData(this.cad).serializeNBT());
        nbt.func_74778_a(tagMessage, ITextComponent.Serializer.func_150696_a((ITextComponent)this.message));
        nbt.func_74768_a(tagComparatorSignal, this.comparatorSignal);
        nbt.func_74768_a(tagSuccessCount, this.successCount);
        return nbt;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189515_b(new CompoundNBT()));
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.read(packet.func_148857_g());
    }

    static {
        statError = new TranslationTextComponent("psimisc.weak_cad");
    }

    public class MPUCaster
    extends FakePlayer {
        private MPUCaster() {
            super((ServerWorld)MPUTile.this.field_145850_b, new GameProfile(UUID.randomUUID(), "MPU"));
            this.field_71135_a = new ServerPlayNetHandler(this.field_71133_b, new NetworkManager(PacketDirection.SERVERBOUND){

                public void func_201058_a(IPacket<?> packet, GenericFutureListener<? extends Future<? super Void>> gfl) {
                }
            }, (ServerPlayerEntity)this);
            this.field_71071_by.field_70462_a.set(0, (Object)MPUTile.this.cad);
            try {
                ObfuscationReflectionHelper.setPrivateValue(Entity.class, (Object)((Object)this), (Object)0, (String)"field_213326_aJ");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public Vector3d func_213303_ch() {
            return new Vector3d((double)MPUTile.this.field_174879_c.func_177958_n() + 0.5, (double)MPUTile.this.field_174879_c.func_177956_o() + 0.5, (double)MPUTile.this.field_174879_c.func_177952_p() + 0.5);
        }

        public BlockPos func_233580_cy_() {
            return MPUTile.this.field_174879_c;
        }

        public Vector3d func_70040_Z() {
            return Vector3d.func_237491_b_((Vector3i)((Direction)this.func_213339_cH().func_177229_b((Property)MPUBlock.field_185512_D)).func_176730_m());
        }

        public void fix() {
            float yaw = ((Direction)this.func_213339_cH().func_177229_b((Property)MPUBlock.field_185512_D)).func_185119_l();
            this.func_70080_a((double)MPUTile.this.field_174879_c.func_177958_n() + 0.5, (double)MPUTile.this.field_174879_c.func_177956_o() + 0.5, (double)MPUTile.this.field_174879_c.func_177952_p() + 0.5, yaw, 0.0f);
            this.field_70759_as = this.field_70177_z;
        }

        public void func_145747_a(ITextComponent component, UUID senderUUID) {
            MPUTile.this.message = component;
            MPUTile.this.func_70296_d();
            MPUTile.this.field_145850_b.func_184138_a(MPUTile.this.field_174879_c, this.func_213339_cH(), this.func_213339_cH(), 18);
        }

        public void deductPsi(int amount, int cd) {
            MPUTile.this.addPsi(-amount);
            MPUTile.this.castDelay += cd;
        }

        public int getPsi() {
            return MPUTile.this.psi;
        }

        public int getMaxPsi() {
            return MPUTile.this.getPsiCapacity();
        }

        public void setComparatorSignal(int value) {
            MPUTile.this.comparatorSignal = Math.max(Math.min(value, 15), 0);
            MPUTile.this.func_70296_d();
            MPUTile.this.field_145850_b.func_184138_a(MPUTile.this.field_174879_c, this.func_213339_cH(), this.func_213339_cH(), 3);
        }

        public void setTime(int time) {
            MPUTile.this.setTime(time);
        }

        public int getSuccessCount() {
            return MPUTile.this.successCount;
        }

        public void fail() {
            MPUTile.this.successCount = 0;
            MPUTile.this.func_70296_d();
        }
    }
}

