/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.tileentity;

import com.mrcrayfish.furniture.core.ModTileEntities;
import com.mrcrayfish.furniture.util.TileEntityUtil;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.model.data.IModelData;

public class TrampolineTileEntity
extends TileEntity {
    private int count = 1;
    private DyeColor colour = DyeColor.WHITE;

    protected TrampolineTileEntity(TileEntityType<?> type) {
        super(type);
    }

    public TrampolineTileEntity() {
        super((TileEntityType)ModTileEntities.TRAMPOLINE.get());
    }

    public void onLoad() {
        TileEntityUtil.sendUpdatePacket(this);
    }

    public void setCount(int count) {
        this.count = count;
        TileEntityUtil.sendUpdatePacket(this);
    }

    public int getCount() {
        return this.count;
    }

    public DyeColor getColour() {
        return this.colour;
    }

    public void setColour(DyeColor colour) {
        this.colour = colour;
    }

    public void updateCount() {
        HashSet<TrampolineTileEntity> trampolines = new HashSet<TrampolineTileEntity>();
        this.isTrampoline(trampolines, this.field_174879_c);
        trampolines.forEach(trampoline -> trampoline.setCount(trampolines.size()));
    }

    private void isTrampoline(Set<TrampolineTileEntity> trampolines, BlockPos pos) {
        if (this.field_145850_b == null) {
            return;
        }
        TileEntity tileEntity = this.field_145850_b.func_175625_s(pos);
        if (tileEntity instanceof TrampolineTileEntity) {
            if (trampolines.contains(tileEntity)) {
                return;
            }
            trampolines.add((TrampolineTileEntity)tileEntity);
            this.isTrampoline(trampolines, pos.func_177972_a(Direction.NORTH));
            this.isTrampoline(trampolines, pos.func_177972_a(Direction.EAST));
            this.isTrampoline(trampolines, pos.func_177972_a(Direction.SOUTH));
            this.isTrampoline(trampolines, pos.func_177972_a(Direction.WEST));
        }
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT compound) {
        super.func_230337_a_(blockState, compound);
        this.readData(compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.writeData(compound);
        return super.func_189515_b(compound);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT compound = pkt.func_148857_g();
        this.readData(compound);
    }

    private void readData(CompoundNBT compound) {
        if (compound.func_150297_b("Count", 3)) {
            this.count = compound.func_74762_e("Count");
        }
        if (compound.func_150297_b("Color", 3)) {
            this.colour = DyeColor.func_196056_a((int)compound.func_74762_e("Color"));
        }
    }

    private CompoundNBT writeData(CompoundNBT compound) {
        compound.func_74768_a("Count", this.count);
        compound.func_74768_a("Color", this.colour.func_196059_a());
        return compound;
    }

    @Nonnull
    public IModelData getModelData() {
        return super.getModelData();
    }
}

