/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.jei;

import com.blamejared.crafttweaker.impl.util.text.MCTextComponent;
import com.blamejared.jeitweaker.bridge.JeiCategoryPluginBridge;
import com.blamejared.jeitweaker.jei.JeiTweakerRecipe;
import com.blamejared.jeitweaker.zen.category.JeiCategory;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public final class JeiTweakerCategory
implements IRecipeCategory<JeiTweakerRecipe> {
    private final JeiCategory zenCategory;
    private final IJeiHelpers helpers;
    private final JeiCategoryPluginBridge bridge;

    JeiTweakerCategory(JeiCategory zenCategory, IJeiHelpers helpers) {
        this.zenCategory = zenCategory;
        this.helpers = helpers;
        this.bridge = zenCategory.getBridgeCreator().get();
    }

    public ResourceLocation getUid() {
        return this.zenCategory.id();
    }

    public Class<? extends JeiTweakerRecipe> getRecipeClass() {
        return JeiTweakerRecipe.class;
    }

    @Deprecated
    public String getTitle() {
        return this.getTitleAsTextComponent().getString();
    }

    public IDrawable getBackground() {
        return this.zenCategory.background().getDrawable(this.helpers.getGuiHelper());
    }

    public IDrawable getIcon() {
        return this.zenCategory.icon().getDrawable(this.helpers.getGuiHelper());
    }

    public void setIngredients(JeiTweakerRecipe recipe, IIngredients ingredients) {
        recipe.setIngredients(ingredients);
    }

    public void setRecipe(IRecipeLayout recipeLayout, JeiTweakerRecipe recipe, IIngredients ingredients) {
        long slotsData = (long)this.bridge.getOutputSlotsAmount() << 32 | (long)this.bridge.getInputSlotsAmount();
        recipe.setRecipe(recipeLayout, this.bridge::initializeGui, slotsData, this.bridge.allowShapelessMarker());
    }

    public ITextComponent getTitleAsTextComponent() {
        return this.zenCategory.name().getInternal();
    }

    public void draw(JeiTweakerRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        this.bridge.drawAdditionalComponent(matrixStack, mouseX, mouseY, this.helpers.getGuiHelper(), recipe::populateGraphics);
    }

    public List<ITextComponent> getTooltipStrings(JeiTweakerRecipe recipe, double mouseX, double mouseY) {
        List recipeTips;
        List<MCTextComponent> categoryTips = this.bridge.getTooltips(mouseX, mouseY, this.helpers.getGuiHelper(), recipe::populateGraphics);
        List<Object> list = recipeTips = this.bridge.allowCustomTooltips() ? recipe.getTooltips(mouseX, mouseY) : Collections.emptyList();
        if (categoryTips.isEmpty() && recipeTips.isEmpty()) {
            return Collections.emptyList();
        }
        Stream stream = categoryTips.isEmpty() ? recipeTips.stream() : (recipeTips.isEmpty() ? categoryTips.stream() : Stream.concat(categoryTips.stream(), recipeTips.stream()));
        return stream.map(MCTextComponent::getInternal).collect(Collectors.toList());
    }

    public boolean handleClick(JeiTweakerRecipe recipe, double mouseX, double mouseY, int mouseButton) {
        return false;
    }

    public boolean isHandled(JeiTweakerRecipe recipe) {
        return recipe.getOwningCategory() == this.zenCategory;
    }
}

