/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.implementation.state;

import com.blamejared.jeitweaker.api.CoordinateFixer;
import com.blamejared.jeitweaker.api.IngredientEnumerator;
import com.blamejared.jeitweaker.api.IngredientType;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;

public final class RegistrationState {
    private final Map<ResourceLocation, IngredientType<?, ?>> ingredientTypes = new HashMap();
    private final Map<IngredientType<?, ?>, CoordinateFixer> coordinateFixers = new HashMap();
    private final Map<IngredientType<?, ?>, IngredientEnumerator<?, ?>> ingredientEnumerators = new HashMap();

    RegistrationState() {
    }

    public <T, U> void registerIngredientType(ResourceLocation id, IngredientType<T, U> ingredientType) {
        if (this.ingredientTypes.containsKey(id)) {
            throw new IllegalArgumentException("Ingredient type " + id + " is already known");
        }
        this.ingredientTypes.put(id, ingredientType);
    }

    public <T, U> void registerCoordinateFixer(IngredientType<T, U> ingredientType, CoordinateFixer fixer) {
        if (this.coordinateFixers.containsKey(ingredientType)) {
            throw new IllegalArgumentException("Ingredient type " + ingredientType + " is already coordinate-fixed");
        }
        this.coordinateFixers.put(ingredientType, fixer);
    }

    public <T, U> void registerIngredientEnumerator(IngredientType<T, U> ingredientType, IngredientEnumerator<T, U> enumerator) {
        if (this.ingredientEnumerators.containsKey(ingredientType)) {
            throw new IllegalArgumentException("Ingredient type " + ingredientType + " already has an enumerator");
        }
        this.ingredientEnumerators.put(ingredientType, enumerator);
    }

    public Stream<IngredientType<?, ?>> ingredientTypes() {
        return this.ingredientTypes.values().stream();
    }

    public Stream<Map.Entry<IngredientType<?, ?>, CoordinateFixer>> rawFixers() {
        return this.coordinateFixers.entrySet().stream();
    }

    public Stream<Map.Entry<IngredientType<?, ?>, IngredientEnumerator<?, ?>>> ingredientEnumerators() {
        return this.ingredientEnumerators.entrySet().stream();
    }
}

