/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.bridge;

import com.blamejared.crafttweaker.impl.util.text.MCTextComponent;
import com.blamejared.jeitweaker.api.CoordinateFixer;
import com.blamejared.jeitweaker.bridge.JeiCategoryPluginBridge;
import com.blamejared.jeitweaker.zen.component.JeiDrawable;
import com.blamejared.jeitweaker.zen.recipe.RecipeGraphics;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.helpers.IGuiHelper;

public final class CatalystRequiringRecipeCategoryBridge
implements JeiCategoryPluginBridge {
    private static final int FIRST_IN_X = 44;
    private static final int FIRST_IN_Y = 3;
    private static final int FIRST_OUT_X = 100;
    private static final int FIRST_OUT_Y = 3;
    private static final int CATALYST_X = 72;
    private static final int CATALYST_Y = 23;
    private static final int ARROW_X = 72;
    private static final int ARROW_Y = 5;
    private static final int ARROW_W = 18;
    private static final int ARROW_H = 13;
    private final JeiDrawable cover;
    private final JeiDrawable catalyst;
    private final int inputs;
    private final int outputs;
    private final int maxInputs;
    private final int maxOutputs;
    private final boolean hasCatalyst;
    private final int firstInput;
    private final int inputsAndCatalyst;

    public CatalystRequiringRecipeCategoryBridge(JeiDrawable cover, JeiDrawable catalyst, int inputs, int outputs, int maxInputs, int maxOutputs) {
        this.cover = cover;
        this.catalyst = catalyst;
        this.inputs = inputs;
        this.outputs = outputs;
        this.maxInputs = maxInputs;
        this.maxOutputs = maxOutputs;
        this.hasCatalyst = this.catalyst == null;
        this.firstInput = this.hasCatalyst ? 1 : 0;
        this.inputsAndCatalyst = this.inputs + this.firstInput;
    }

    @Override
    public <G> void initializeGui(IGuiIngredientGroup<G> group, CoordinateFixer coordinateFixer) {
        int x;
        int index;
        int i;
        if (this.hasCatalyst) {
            group.init(0, true, coordinateFixer.fixX(73), coordinateFixer.fixY(24));
        }
        for (i = 0; i < this.inputs; ++i) {
            index = this.firstInput + i;
            x = 45 - i * 18;
            group.init(index, true, coordinateFixer.fixX(x), coordinateFixer.fixY(4));
        }
        for (i = 0; i < this.outputs; ++i) {
            index = this.inputsAndCatalyst + i;
            x = 101 + i * 18;
            group.init(index, false, coordinateFixer.fixX(x), coordinateFixer.fixY(4));
        }
    }

    @Override
    public int getInputSlotsAmount() {
        return this.inputsAndCatalyst;
    }

    @Override
    public int getOutputSlotsAmount() {
        return this.outputs;
    }

    @Override
    public boolean allowShapelessMarker() {
        return false;
    }

    @Override
    public boolean allowCustomTooltips() {
        return false;
    }

    @Override
    public void drawAdditionalComponent(MatrixStack poseStack, double mouseX, double mouseY, IGuiHelper guiHelper, Consumer<RecipeGraphics> graphicsConsumer) {
        this.drawCovers(poseStack, guiHelper);
        this.drawCatalyst(poseStack, guiHelper);
    }

    @Override
    public List<MCTextComponent> getTooltips(double x, double y, IGuiHelper helper, Consumer<RecipeGraphics> graphicsConsumer) {
        if (this.isInsideArrow(x, y)) {
            return this.gatherArrowTip(graphicsConsumer);
        }
        return Collections.emptyList();
    }

    private void drawCovers(MatrixStack poseStack, IGuiHelper helper) {
        IDrawable cover = this.cover.getDrawable(helper);
        this.drawInputCovers(poseStack, cover);
        this.drawOutputCovers(poseStack, cover);
        this.drawCatalystCover(poseStack, cover);
    }

    private void drawInputCovers(MatrixStack poseStack, IDrawable cover) {
        for (int i = this.inputs; i < this.maxInputs; ++i) {
            int x = 44 - i * 18;
            cover.draw(poseStack, x, 3);
        }
    }

    private void drawOutputCovers(MatrixStack poseStack, IDrawable cover) {
        for (int i = this.outputs; i < this.maxOutputs; ++i) {
            int x = 100 + i * 18;
            cover.draw(poseStack, x, 3);
        }
    }

    private void drawCatalystCover(MatrixStack poseStack, IDrawable cover) {
        if (this.hasCatalyst) {
            return;
        }
        cover.draw(poseStack, 72, 23);
    }

    private void drawCatalyst(MatrixStack poseStack, IGuiHelper helper) {
        if (this.hasCatalyst) {
            return;
        }
        IDrawable drawable = this.catalyst.getDrawable(helper);
        drawable.draw(poseStack, 72, 23);
    }

    private boolean isInsideArrow(double mouseX, double mouseY) {
        return 72.0 <= mouseX && mouseX <= 90.0 && 5.0 <= mouseY && mouseY <= 18.0;
    }

    private List<MCTextComponent> gatherArrowTip(Consumer<RecipeGraphics> graphicsConsumer) {
        TooltipDetailGatherer graphics = new TooltipDetailGatherer();
        graphicsConsumer.accept(graphics);
        MCTextComponent[] tip = graphics.tip();
        return tip == null ? Collections.emptyList() : Arrays.asList(tip);
    }

    private static final class TooltipDetailGatherer
    implements RecipeGraphics {
        private static final String TIP_ID = "process_detail";
        private MCTextComponent[] tip = null;

        TooltipDetailGatherer() {
        }

        @Override
        public void addTooltip(String key, MCTextComponent ... lines) {
            if (TIP_ID.equals(key)) {
                this.tip = lines;
            }
        }

        MCTextComponent[] tip() {
            return this.tip;
        }
    }
}

