/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.api;

import com.blamejared.jeitweaker.api.IngredientType;
import com.blamejared.jeitweaker.api.IngredientTypeRegistration;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;

public final class IngredientTypeHolder<T, U>
implements Supplier<IngredientType<T, U>> {
    private Function<IngredientTypeRegistration, IngredientType<T, U>> registrationFunction;
    private IngredientType<T, U> ingredient;

    private IngredientTypeHolder(Function<IngredientTypeRegistration, IngredientType<T, U>> registration) {
        this.registrationFunction = registration;
        this.ingredient = null;
    }

    public static <T, U> IngredientTypeHolder<T, U> of(ResourceLocation id, Class<T> jeiTweakerType, Class<U> jeiType, Function<T, U> toJeiTypeConverter, Function<U, T> toJeiTweakerTypeConverter, Function<T, ResourceLocation> toIdentifierConverter, BiPredicate<T, T> matcher) {
        return new IngredientTypeHolder<T, U>(reg -> reg.registerIngredientType(id, jeiTweakerType, jeiType, toJeiTypeConverter, toJeiTweakerTypeConverter, toIdentifierConverter, matcher));
    }

    @Override
    public IngredientType<T, U> get() {
        return Objects.requireNonNull(this.ingredient, "Queried ingredient too early");
    }

    public void registerTo(IngredientTypeRegistration registration) {
        this.ingredient = this.registrationFunction.apply(registration);
        this.registrationFunction = null;
    }
}

