/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.actions;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IUndoableAction;
import com.blamejared.jeitweaker.implementation.state.StateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;

public final class ActionHideRecipe
implements IUndoableAction {
    private final ResourceLocation category;
    private final ResourceLocation recipeName;

    public ActionHideRecipe(ResourceLocation category, ResourceLocation recipeName) {
        this.category = category;
        this.recipeName = recipeName;
    }

    public void apply() {
        StateManager.INSTANCE.actionsState().hideRecipe(this.category, this.recipeName);
    }

    public void undo() {
        StateManager.INSTANCE.actionsState().showRecipe(this.category, this.recipeName);
    }

    public String describeUndo() {
        return "Undoing JEI hiding recipe: " + this.recipeName + " in category: " + this.category;
    }

    public String describe() {
        return "JEI Hiding recipe: " + this.recipeName + " in category: " + this.category;
    }

    public boolean shouldApplyOn(LogicalSide side) {
        return !CraftTweakerAPI.isServer();
    }
}

