/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.network.server;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class SPacketBreak {
    private int entityId;
    private int slotId;
    private String curioId;

    public SPacketBreak(int entityId, String curioId, int slotId) {
        this.entityId = entityId;
        this.slotId = slotId;
        this.curioId = curioId;
    }

    public static void encode(SPacketBreak msg, PacketBuffer buf) {
        buf.writeInt(msg.entityId);
        buf.func_180714_a(msg.curioId);
        buf.writeInt(msg.slotId);
    }

    public static SPacketBreak decode(PacketBuffer buf) {
        return new SPacketBreak(buf.readInt(), buf.func_150789_c(25), buf.readInt());
    }

    public static void handle(SPacketBreak msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity;
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (world != null && (entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(msg.entityId)) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                CuriosApi.getCuriosHelper().getCuriosHandler(livingEntity).ifPresent(handler -> {
                    ItemStack stack = handler.getStacksHandler(msg.curioId).map(stacksHandler -> stacksHandler.getStacks().getStackInSlot(msg.slotId)).orElse(ItemStack.field_190927_a);
                    LazyOptional<ICurio> possibleCurio = CuriosApi.getCuriosHelper().getCurio(stack);
                    possibleCurio.ifPresent(curio -> curio.curioBreak(stack, livingEntity));
                    if (!possibleCurio.isPresent()) {
                        ICurio.playBreakAnimation(stack, livingEntity);
                    }
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

