/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.setup;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.compat.CompatHandler;
import net.mehvahdjukaar.supplementaries.configs.RegistryConfigs;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.LootTableLoadEvent;

public class LootTableStuff {
    private static final List<BiConsumer<LootTableLoadEvent, TableType>> LOOT_INJECTS = new ArrayList<BiConsumer<LootTableLoadEvent, TableType>>();

    public static void init() {
        if (((Boolean)RegistryConfigs.reg.GLOBE_ENABLED.get()).booleanValue()) {
            LOOT_INJECTS.add(LootTableStuff::tryInjectGlobe);
        }
        if (((Boolean)RegistryConfigs.reg.ROPE_ENABLED.get()).booleanValue()) {
            LOOT_INJECTS.add(LootTableStuff::tryInjectRope);
        }
        if (((Boolean)RegistryConfigs.reg.FLAX_ENABLED.get()).booleanValue()) {
            LOOT_INJECTS.add(LootTableStuff::tryInjectFlax);
        }
        if (((Boolean)RegistryConfigs.reg.BOMB_ENABLED.get()).booleanValue()) {
            LOOT_INJECTS.add(LootTableStuff::tryInjectBlueBomb);
        }
        if (((Boolean)RegistryConfigs.reg.BOMB_ENABLED.get()).booleanValue()) {
            LOOT_INJECTS.add(LootTableStuff::tryInjectBomb);
        }
        if (((Boolean)RegistryConfigs.reg.SLINGSHOT_ENABLED.get()).booleanValue()) {
            LOOT_INJECTS.add(LootTableStuff::tryInjectStasis);
        }
        if (((Boolean)RegistryConfigs.reg.BAMBOO_SPIKES_ENABLED.get()).booleanValue() && ((Boolean)RegistryConfigs.reg.TIPPED_SPIKES_ENABLED.get()).booleanValue()) {
            LOOT_INJECTS.add(LootTableStuff::tryInjectSpikes);
        }
    }

    public static void injectLootTables(LootTableLoadEvent event) {
        TableType type;
        ResourceLocation res = event.getName();
        String nameSpace = res.func_110624_b();
        if ((nameSpace.equals("minecraft") || nameSpace.equals("repurposed_structures")) && (type = LootHelper.getType(res.toString())) != TableType.OTHER) {
            LOOT_INJECTS.forEach(i -> i.accept(event, type));
        }
    }

    private static void injectLootPool(LootTableLoadEvent event, TableType type, String name) {
        String id = type.toString().toLowerCase() + "_" + name;
        LootPool pool = LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)Supplementaries.res("inject/" + id))).name("supp_" + name).func_216044_b();
        event.getTable().addPool(pool);
    }

    public static void tryInjectGlobe(LootTableLoadEvent e, TableType type) {
        if (type == TableType.SHIPWRECK_TREASURE) {
            LootTableStuff.injectLootPool(e, type, "globe");
        }
    }

    public static void tryInjectRope(LootTableLoadEvent e, TableType type) {
        if (type == TableType.MINESHAFT) {
            LootTableStuff.injectLootPool(e, type, "rope");
        }
    }

    public static void tryInjectFlax(LootTableLoadEvent e, TableType type) {
        if (type == TableType.MINESHAFT || type == TableType.DUNGEON || type == TableType.SHIPWRECK_STORAGE || type == TableType.PILLAGER) {
            LootTableStuff.injectLootPool(e, type, "flax");
        }
    }

    public static void tryInjectBlueBomb(LootTableLoadEvent e, TableType type) {
        if (type == TableType.STRONGHOLD || type == TableType.MINESHAFT || type == TableType.TEMPLE || type == TableType.FORTRESS || type == TableType.DUNGEON) {
            LootTableStuff.injectLootPool(e, type, "blue_bomb");
        }
    }

    public static void tryInjectBomb(LootTableLoadEvent e, TableType type) {
        if (type == TableType.STRONGHOLD || type == TableType.MINESHAFT || type == TableType.TEMPLE || type == TableType.FORTRESS) {
            LootTableStuff.injectLootPool(e, type, "bomb");
        }
    }

    public static void tryInjectSpikes(LootTableLoadEvent e, TableType type) {
        if (type == TableType.TEMPLE) {
            LootTableStuff.injectLootPool(e, type, "spikes");
        }
    }

    public static void tryInjectStasis(LootTableLoadEvent e, TableType type) {
        if (type == TableType.END_CITY) {
            LootTableStuff.injectLootPool(e, type, "stasis");
        }
    }

    private static class LootHelper {
        static boolean RS = CompatHandler.repurposed_structures;
        private static final Pattern RS_SHIPWRECK = Pattern.compile("repurposed_structures:chests/shipwreck/\\w*/treasure_chest");
        private static final Pattern RS_SHIPWRECK_STORAGE = Pattern.compile("repurposed_structures:chests/shipwreck/\\w*/supply_chest");
        private static final Pattern RS_TEMPLE = Pattern.compile("repurposed_structures:chests/temple/\\w*_chest");
        private static final Pattern RS_TEMPLE_DISPENSER = Pattern.compile("repurposed_structures:chests/temple/\\w*_dispenser");

        private LootHelper() {
        }

        public static TableType getType(String name) {
            if (LootHelper.isShipwreck(name)) {
                return TableType.SHIPWRECK_TREASURE;
            }
            if (LootHelper.isShipwreckStorage(name)) {
                return TableType.SHIPWRECK_STORAGE;
            }
            if (LootHelper.isMineshaft(name)) {
                return TableType.MINESHAFT;
            }
            if (LootHelper.isDungeon(name)) {
                return TableType.DUNGEON;
            }
            if (LootHelper.isTemple(name)) {
                return TableType.TEMPLE;
            }
            if (LootHelper.isTempleDispenser(name)) {
                return TableType.TEMPLE_DISPENSER;
            }
            if (LootHelper.isOutpost(name)) {
                return TableType.PILLAGER;
            }
            if (LootHelper.isStronghold(name)) {
                return TableType.STRONGHOLD;
            }
            if (LootHelper.isFortress(name)) {
                return TableType.FORTRESS;
            }
            if (LootHelper.isEndCity(name)) {
                return TableType.END_CITY;
            }
            return TableType.OTHER;
        }

        private static boolean isShipwreck(String s) {
            return s.equals(LootTables.field_204773_u.toString()) || RS && RS_SHIPWRECK.matcher(s).matches();
        }

        private static boolean isShipwreckStorage(String s) {
            return s.equals(LootTables.field_204772_t.toString()) || RS && RS_SHIPWRECK_STORAGE.matcher(s).matches();
        }

        private static boolean isMineshaft(String s) {
            return s.equals(LootTables.field_186424_f.toString()) || RS && s.contains("repurposed_structures:chests/mineshaft");
        }

        private static boolean isOutpost(String s) {
            return s.equals(LootTables.field_215813_K.toString()) || RS && s.contains("repurposed_structures:chests/outpost");
        }

        private static boolean isDungeon(String s) {
            return s.equals(LootTables.field_186422_d.toString()) || RS && s.contains("repurposed_structures:chests/dungeon");
        }

        private static boolean isTemple(String s) {
            return s.equals(LootTables.field_186430_l.toString()) || RS && RS_TEMPLE.matcher(s).matches();
        }

        private static boolean isTempleDispenser(String s) {
            return s.equals(LootTables.field_186430_l.toString()) || RS && RS_TEMPLE_DISPENSER.matcher(s).matches();
        }

        private static boolean isStronghold(String s) {
            return s.equals(LootTables.field_186427_i.toString()) || RS && s.contains("repurposed_structures:chests/stronghold/nether_storage_room");
        }

        private static boolean isFortress(String s) {
            return s.equals(LootTables.field_186425_g.toString()) || RS && s.contains("repurposed_structures:chests/fortress");
        }

        private static boolean isEndCity(String s) {
            return s.equals(LootTables.field_186421_c.toString());
        }
    }

    public static enum TableType {
        OTHER,
        MINESHAFT,
        SHIPWRECK_TREASURE,
        PILLAGER,
        DUNGEON,
        PYRAMID,
        STRONGHOLD,
        TEMPLE,
        TEMPLE_DISPENSER,
        IGLOO,
        MANSION,
        FORTRESS,
        BASTION,
        RUIN,
        SHIPWRECK_STORAGE,
        END_CITY;

    }
}

