/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.entities.goals;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffer;

public class ShowWaresGoal
extends LookAtGoal {
    protected final AbstractVillagerEntity villager;
    private PlayerEntity player;
    private final int minDuration;
    private final int maxDuration;
    private final List<ItemStack> displayItems = Lists.newArrayList();
    @Nullable
    private ItemStack playerItemStack;
    private int cycleCounter;
    private int displayIndex;
    private int lookTime;

    public ShowWaresGoal(AbstractVillagerEntity mob, int minDuration, int maxDuration) {
        super((MobEntity)mob, PlayerEntity.class, 8.0f);
        this.villager = mob;
        this.minDuration = minDuration;
        this.maxDuration = maxDuration;
    }

    public boolean func_75250_a() {
        if (!this.villager.func_213716_dX()) {
            return super.func_75250_a();
        }
        return false;
    }

    public boolean func_75253_b() {
        if (!this.field_75334_a.func_70089_S()) {
            return false;
        }
        if (this.villager.func_213716_dX()) {
            return false;
        }
        if (this.field_75332_b.func_70068_e(this.field_75334_a) > (double)(this.field_75333_c * this.field_75333_c)) {
            return false;
        }
        return this.lookTime > 0;
    }

    public void func_75249_e() {
        this.lookTime = 40;
        this.cycleCounter = 0;
        this.displayIndex = 0;
        this.player = (PlayerEntity)this.field_75334_a;
    }

    public void func_75246_d() {
        this.findItemsToDisplay();
        if (!this.displayItems.isEmpty()) {
            this.displayCyclingItems();
        } else {
            this.villager.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
        }
        --this.lookTime;
        super.func_75246_d();
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.villager.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
        this.playerItemStack = null;
    }

    private void findItemsToDisplay() {
        boolean flag = false;
        ItemStack handStack = this.player.func_184614_ca();
        if (this.playerItemStack == null || !ItemStack.func_179545_c((ItemStack)this.playerItemStack, (ItemStack)handStack)) {
            this.playerItemStack = handStack;
            flag = true;
            this.displayItems.clear();
        }
        if (flag && !this.playerItemStack.func_190926_b()) {
            this.updateDisplayItems();
            if (!this.displayItems.isEmpty()) {
                this.lookTime = 900;
                this.displayFirstItem();
            }
        }
    }

    private void displayFirstItem() {
        this.villager.func_184201_a(EquipmentSlotType.MAINHAND, this.displayItems.get(0));
    }

    private void updateDisplayItems() {
        for (MerchantOffer merchantoffer : this.villager.func_213706_dY()) {
            if (merchantoffer.func_222217_o() || !this.playerItemStackMatchesCostOfOffer(merchantoffer)) continue;
            this.displayItems.add(merchantoffer.func_222200_d());
        }
    }

    private boolean playerItemStackMatchesCostOfOffer(MerchantOffer offer) {
        return ItemStack.func_179545_c((ItemStack)this.playerItemStack, (ItemStack)offer.func_222205_b()) || ItemStack.func_179545_c((ItemStack)this.playerItemStack, (ItemStack)offer.func_222202_c());
    }

    private void displayCyclingItems() {
        if (this.displayItems.size() >= 2 && ++this.cycleCounter >= 40) {
            ++this.displayIndex;
            this.cycleCounter = 0;
            if (this.displayIndex > this.displayItems.size() - 1) {
                this.displayIndex = 0;
            }
            this.field_75332_b.func_184201_a(EquipmentSlotType.MAINHAND, this.displayItems.get(this.displayIndex));
        }
    }
}

