/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.entities.goals;

import java.util.EnumSet;
import java.util.Random;
import net.mehvahdjukaar.supplementaries.block.blocks.FodderBlock;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;

public class EatFodderGoal
extends MoveToBlockGoal {
    private final AnimalEntity animal;
    private final int blockBreakingTime;
    private int ticksSinceReachedGoal;
    protected int lastBreakProgress = -1;
    private final BlockState FODDER_STATE = ((Block)ModRegistry.FODDER.get()).func_176223_P();

    public EatFodderGoal(AnimalEntity entity2, double speedModifier, int searchRange, int verticalSearchRange, int breakTime) {
        super((CreatureEntity)entity2, speedModifier, searchRange, verticalSearchRange);
        this.animal = entity2;
        this.blockBreakingTime = breakTime;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        if (!this.animal.func_204701_dC() || this.animal.func_70874_b() > 0) {
            return false;
        }
        if (this.field_179496_a > 0) {
            --this.field_179496_a;
            return false;
        }
        if (!ForgeHooks.canEntityDestroy((World)this.animal.field_70170_p, (BlockPos)this.field_179494_b, (LivingEntity)this.animal)) {
            return false;
        }
        if (this.tryFindBlock()) {
            this.field_179496_a = 600;
            return true;
        }
        this.field_179496_a = this.func_203109_a(this.field_179495_c);
        return false;
    }

    public boolean func_75253_b() {
        return this.field_179493_e >= -100 && this.field_179493_e <= 200 && this.func_179488_a((IWorldReader)this.field_179495_c.field_70170_p, this.field_179494_b);
    }

    private boolean tryFindBlock() {
        return this.field_179494_b != null && this.func_179488_a((IWorldReader)this.field_179495_c.field_70170_p, this.field_179494_b) || this.func_179489_g();
    }

    protected int func_203109_a(CreatureEntity p_203109_1_) {
        return 800 + p_203109_1_.func_70681_au().nextInt(400);
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.animal.field_70143_R = 1.0f;
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.ticksSinceReachedGoal = 0;
    }

    public double func_203110_f() {
        return 1.4;
    }

    public void func_75246_d() {
        super.func_75246_d();
        World world = this.animal.field_70170_p;
        Random random = this.animal.func_70681_au();
        if (this.func_179487_f()) {
            int k;
            --this.field_179493_e;
            BlockPos targetPos = this.func_241846_j().func_177977_b();
            Vector3d vector3d = Vector3d.func_237492_c_((Vector3i)targetPos);
            this.field_179495_c.func_70671_ap().func_220679_a(vector3d.func_82615_a(), vector3d.func_82617_b(), vector3d.func_82616_c());
            if (this.ticksSinceReachedGoal > 0 && !world.field_72995_K && this.ticksSinceReachedGoal % 2 == 0) {
                ((ServerWorld)world).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, this.FODDER_STATE), (double)targetPos.func_177958_n() + 0.5, (double)targetPos.func_177956_o() + 0.7, (double)targetPos.func_177952_p() + 0.5, 3, ((double)random.nextFloat() - 0.5) * 0.08, ((double)random.nextFloat() - 0.5) * 0.08, ((double)random.nextFloat() - 0.5) * 0.08, (double)0.15f);
            }
            if (this.ticksSinceReachedGoal == 1 && this.animal instanceof SheepEntity) {
                world.func_72960_a((Entity)this.field_179495_c, (byte)10);
            }
            if ((k = (int)((float)this.ticksSinceReachedGoal / (float)this.blockBreakingTime * 10.0f)) != this.lastBreakProgress) {
                this.field_179495_c.field_70170_p.func_175715_c(this.field_179495_c.func_145782_y(), this.field_179494_b, k);
                this.lastBreakProgress = k;
            }
            if (this.ticksSinceReachedGoal > this.blockBreakingTime) {
                int layers = (Integer)world.func_180495_p(targetPos).func_177229_b((Property)FodderBlock.LAYERS);
                if (layers > 2) {
                    world.func_217379_c(2001, targetPos, Block.func_196246_j((BlockState)this.FODDER_STATE));
                    world.func_180501_a(targetPos, (BlockState)this.FODDER_STATE.func_206870_a((Property)FodderBlock.LAYERS, (Comparable)Integer.valueOf(layers - 2)), 2);
                } else {
                    world.func_175655_b(targetPos, false);
                }
                if (!world.field_72995_K) {
                    ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197632_y, this.animal.func_226277_ct_(), this.animal.func_226278_cu_(), this.animal.func_226281_cx_(), 5, (double)(this.animal.func_213311_cf() / 2.0f), (double)(this.animal.func_213302_cg() / 2.0f), (double)(this.animal.func_213311_cf() / 2.0f), 0.0);
                }
                this.field_179496_a = this.func_203109_a(this.field_179495_c);
                this.field_179493_e = 800;
                if (!this.animal.func_70631_g_()) {
                    this.animal.func_146082_f(null);
                }
                this.animal.func_70615_aA();
            }
            ++this.ticksSinceReachedGoal;
        }
    }

    protected boolean func_179488_a(IWorldReader world, BlockPos pos) {
        IChunk ichunk = world.func_217353_a(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4, ChunkStatus.field_222617_m, false);
        if (ichunk == null) {
            return false;
        }
        return ichunk.func_180495_p(pos).func_203425_a((Block)ModRegistry.FODDER.get()) && ichunk.func_180495_p(pos.func_177984_a()).func_196958_f();
    }
}

