/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import java.util.UUID;
import net.mehvahdjukaar.selene.blocks.IOwnerProtected;
import net.mehvahdjukaar.supplementaries.block.tiles.SwayingBlockTile;
import net.mehvahdjukaar.supplementaries.block.util.IMapDisplay;
import net.mehvahdjukaar.supplementaries.block.util.ITextHolderProvider;
import net.mehvahdjukaar.supplementaries.block.util.TextHolder;
import net.mehvahdjukaar.supplementaries.client.gui.HangingSignGui;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.NonNullList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class HangingSignBlockTile
extends SwayingBlockTile
implements IMapDisplay,
ITextHolderProvider,
IOwnerProtected {
    public static final int MAXLINES = 7;
    private UUID owner = null;
    public TextHolder textHolder;
    private NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);

    public HangingSignBlockTile() {
        super((TileEntityType)ModRegistry.HANGING_SIGN_TILE.get());
        this.textHolder = new TextHolder(7);
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    @Override
    public TextHolder getTextHolder() {
        return this.textHolder;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Screen getScreen() {
        return new HangingSignGui(this);
    }

    @Override
    public ItemStack getMapStack() {
        return this.getStackInSlot(0);
    }

    public void func_70296_d() {
        if (this.field_145850_b == null) {
            return;
        }
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        super.func_70296_d();
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.stacks = NonNullList.func_191197_a((int)this.getSizeInventory(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)compound, this.stacks);
        this.textHolder.read(compound);
        this.loadOwner(compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.stacks);
        this.textHolder.write(compound);
        this.saveOwner(compound);
        return compound;
    }

    public int getSizeInventory() {
        return this.stacks.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    protected NonNullList<ItemStack> getItems() {
        return this.stacks;
    }

    public void setItems(NonNullList<ItemStack> stacks) {
        this.stacks = stacks;
    }

    public ItemStack removeStackFromSlot(int index) {
        return ItemStackHelper.func_188383_a(this.getItems(), (int)index);
    }

    public ItemStack getStackInSlot(int index) {
        return (ItemStack)this.getItems().get(index);
    }

    static {
        maxSwingAngle = 45.0f;
        minSwingAngle = 2.5f;
        maxPeriod = 25.0f;
        angleDamping = 150.0f;
        periodDamping = 100.0f;
    }
}

