/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import java.util.Objects;
import net.mehvahdjukaar.selene.blocks.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.block.blocks.ItemShelfBlock;
import net.mehvahdjukaar.supplementaries.block.util.IBlockHolder;
import net.mehvahdjukaar.supplementaries.common.FlowerPotHandler;
import net.mehvahdjukaar.supplementaries.common.ModTags;
import net.mehvahdjukaar.supplementaries.compat.CompatHandler;
import net.mehvahdjukaar.supplementaries.compat.dynamictrees.DynamicTreesCompat;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class FlowerBoxBlockTile
extends ItemDisplayTile
implements IBlockHolder {
    public static final ModelProperty<BlockState> FLOWER_0 = new ModelProperty();
    public static final ModelProperty<BlockState> FLOWER_1 = new ModelProperty();
    public static final ModelProperty<BlockState> FLOWER_2 = new ModelProperty();
    private final BlockState[] flowerStates = new BlockState[]{Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P()};

    public FlowerBoxBlockTile() {
        super((TileEntityType)ModRegistry.FLOWER_BOX_TILE.get(), 3);
    }

    @Override
    public BlockState getHeldBlock(int index) {
        return this.flowerStates[index];
    }

    @Override
    public boolean setHeldBlock(BlockState state, int index) {
        if (index >= 0 && index < 3) {
            this.flowerStates[index] = state;
        }
        return false;
    }

    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(FLOWER_0, (Object)this.flowerStates[0]).withInitial(FLOWER_1, (Object)this.flowerStates[1]).withInitial(FLOWER_2, (Object)this.flowerStates[2]).build();
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        BlockState oldMimic0 = this.flowerStates[0];
        BlockState oldMimic1 = this.flowerStates[1];
        BlockState oldMimic2 = this.flowerStates[2];
        CompoundNBT tag = pkt.func_148857_g();
        this.handleUpdateTag(this.func_195044_w(), tag);
        if (!(Objects.equals(oldMimic0, this.flowerStates[0]) && Objects.equals(oldMimic1, this.flowerStates[1]) && Objects.equals(oldMimic2, this.flowerStates[2]))) {
            ModelDataManager.requestModelDataRefresh((TileEntity)this);
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c).func_72317_d(0.0, 0.25, 0.0);
    }

    public void updateClientVisualsOnLoad() {
        for (int n = 0; n < this.flowerStates.length; ++n) {
            Item item2 = this.func_70301_a(n).func_77973_b();
            Block b = null;
            if (item2 instanceof BlockItem) {
                b = ((BlockItem)item2).func_179223_d();
            } else if (CompatHandler.dynamictrees) {
                b = DynamicTreesCompat.getOptionalDynamicSapling(item2, this.field_145850_b, this.field_174879_c);
            }
            if (b == null) {
                b = Blocks.field_150350_a;
            }
            this.flowerStates[n] = b.func_176223_P();
        }
        ModelDataManager.requestModelDataRefresh((TileEntity)this);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
    }

    public ITextComponent func_213907_g() {
        return new TranslationTextComponent("block.supplementaries.flower_box");
    }

    public float getYaw() {
        return -this.getDirection().func_176734_d().func_185119_l();
    }

    public Direction getDirection() {
        return (Direction)this.func_195044_w().func_177229_b((Property)ItemShelfBlock.FACING);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (this.func_70301_a(index).func_190926_b()) {
            Item item2 = stack.func_77973_b();
            return item2.func_206844_a(ModTags.FLOWER_BOX_PLANTABLE) || FlowerPotHandler.hasSpecialFlowerModel(item2);
        }
        return false;
    }
}

