/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Executors;
import net.mehvahdjukaar.selene.blocks.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.block.blocks.EnhancedLanternBlock;
import net.mehvahdjukaar.supplementaries.block.blocks.NoticeBoardBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.NoticeBoardBlockTile;
import net.mehvahdjukaar.supplementaries.block.tiles.SignPostBlockTile;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.mehvahdjukaar.supplementaries.world.structures.RoadSignFeature;
import net.mehvahdjukaar.supplementaries.world.structures.StructureLocator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LanternBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class BlockGeneratorBlockTile
extends TileEntity
implements ITickableTileEntity {
    private boolean firstTick = true;
    public Pair<List<Pair<Integer, BlockPos>>, Boolean> threadResult = null;
    private static final BlockState trapdoor = Blocks.field_196638_cX.func_176223_P();
    private static final BlockState lantern = (BlockState)Blocks.field_222432_lU.func_176223_P().func_206870_a((Property)LanternBlock.field_220278_a, (Comparable)Boolean.valueOf(true));
    private static final BlockState lanternDown = Blocks.field_222432_lU.func_176223_P();
    private static final BlockState fence = Blocks.field_180408_aP.func_176223_P();
    private static final BlockState jar = ((Block)ModRegistry.FIREFLY_JAR.get()).func_176223_P();
    private static final BlockState slab = Blocks.field_196624_br.func_176223_P();
    private static final BlockState log = Blocks.field_203205_S.func_176223_P();
    private static final BlockState stoneSlab = Blocks.field_150333_U.func_176223_P();
    private static final BlockState stone = Blocks.field_150348_b.func_176223_P();
    private static final BlockState stair = Blocks.field_222438_lb.func_176223_P();
    private static final BlockState air = Blocks.field_150350_a.func_176223_P();
    private static final BlockState path = Blocks.field_185774_da.func_176223_P();
    private static final BlockState path_2 = Blocks.field_196580_bH.func_176223_P();

    public BlockGeneratorBlockTile() {
        super((TileEntityType)ModRegistry.BLOCK_GENERATOR_TILE.get());
    }

    private double averageAngles(float a, float b) {
        a = (float)((double)a * Math.PI / 180.0);
        b = (float)((double)b * Math.PI / 180.0);
        return 57.29577951308232 * MathHelper.func_181159_b((double)(MathHelper.func_76126_a((float)a) + MathHelper.func_76126_a((float)b)), (double)(MathHelper.func_76134_b((float)a) + MathHelper.func_76134_b((float)b)));
    }

    public void func_73660_a() {
        block33: {
            BlockPos pos;
            ServerWorld world;
            if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
                return;
            }
            if (this.firstTick) {
                this.firstTick = false;
                world = (ServerWorld)this.field_145850_b;
                pos = this.field_174879_c.func_177979_c(2);
                int posX = pos.func_177958_n();
                int posZ = pos.func_177952_p();
                try {
                    Executors.newSingleThreadExecutor().submit(() -> {
                        this.threadResult = StructureLocator.find(world, posX, posZ, 2);
                        return this.threadResult;
                    });
                }
                catch (Exception e) {
                    this.field_145850_b.func_217377_a(this.field_174879_c, false);
                    Supplementaries.LOGGER.warn("failed to generate road sign at " + this.field_174879_c.toString() + ": " + e);
                }
            }
            try {
                if (this.threadResult == null) break block33;
                world = (ServerWorld)this.field_145850_b;
                pos = this.field_174879_c.func_177979_c(2);
                BlockState topState = trapdoor;
                Pair<List<Pair<Integer, BlockPos>>, Boolean> locateResult = this.threadResult;
                List villages = (List)locateResult.getLeft();
                boolean inVillage = (Boolean)locateResult.getRight();
                if (inVillage) {
                    RegistryKey b = RegistryKey.func_240903_a_((RegistryKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)world.func_226691_t_(pos).getRegistryName());
                    BlockState replace = b == Biomes.field_76769_d || b == Biomes.field_76786_s || b == Biomes.field_185442_R ? path_2 : path;
                    BlockGeneratorBlockTile.replaceCobbleWithPath((World)world, pos, replace);
                }
                if (villages.size() >= 1) {
                    BlockPos village2;
                    int dist2;
                    BlockPos village1;
                    int dist1;
                    Random rand = this.field_145850_b.field_73012_v;
                    boolean twoSigns = true;
                    if (villages.size() == 1 || 0.3 > (double)rand.nextFloat() && (Integer)((Pair)villages.get(0)).getLeft() > 192) {
                        dist1 = (Integer)((Pair)villages.get(0)).getLeft();
                        village1 = (BlockPos)((Pair)villages.get(0)).getRight();
                        dist2 = dist1;
                        village2 = village1;
                        twoSigns = false;
                    } else {
                        boolean inv = rand.nextBoolean();
                        dist1 = (Integer)((Pair)villages.get(inv ? 0 : 1)).getLeft();
                        village1 = (BlockPos)((Pair)villages.get(inv ? 0 : 1)).getRight();
                        dist2 = (Integer)((Pair)villages.get(inv ? 1 : 0)).getLeft();
                        village2 = (BlockPos)((Pair)villages.get(inv ? 1 : 0)).getRight();
                    }
                    this.field_145850_b.func_180501_a(pos, ((Block)ModRegistry.SIGN_POST.get()).func_176223_P(), 3);
                    TileEntity te = this.field_145850_b.func_175625_s(pos);
                    if (te instanceof SignPostBlockTile) {
                        boolean hasFirefly;
                        Direction backDir;
                        float yaw;
                        float diff;
                        SignPostBlockTile sign = (SignPostBlockTile)te;
                        sign.setHeldBlock(Blocks.field_180408_aP.func_176223_P());
                        boolean left = rand.nextBoolean();
                        sign.up = true;
                        sign.leftUp = left;
                        sign.pointToward(village1, true);
                        sign.down = twoSigns;
                        sign.leftDown = left;
                        sign.pointToward(village2, false);
                        if (Math.abs(sign.yawUp - sign.yawDown) > 90.0f) {
                            sign.leftDown = !sign.leftDown;
                            sign.pointToward(village2, false);
                        }
                        if (ServerConfigs.cached.DISTANCE_TEXT) {
                            sign.textHolder.setText(0, BlockGeneratorBlockTile.getSignText(dist1));
                            if (twoSigns) {
                                sign.textHolder.setText(1, BlockGeneratorBlockTile.getSignText(dist2));
                            }
                        }
                        Direction sideDir = (diff = MathHelper.func_203302_c((float)(yaw = MathHelper.func_76142_g((float)(90.0f + (float)this.averageAngles(-sign.yawUp + 180.0f, -sign.yawDown + 180.0f)))), (float)(backDir = Direction.func_176733_a((double)yaw)).func_185119_l())) < 0.0f ? backDir.func_176746_e() : backDir.func_176735_f();
                        ArrayList<Direction> lampDir = new ArrayList<Direction>();
                        lampDir.add(backDir.func_176734_d());
                        lampDir.add(backDir.func_176734_d());
                        lampDir.add(backDir.func_176734_d());
                        if (Math.abs(diff) > 30.0f) {
                            lampDir.add(sideDir.func_176734_d());
                        }
                        boolean hasGroundLantern = false;
                        RegistryKey biome = RegistryKey.func_240903_a_((RegistryKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)world.func_226691_t_(pos).getRegistryName());
                        boolean bl = hasFirefly = (BiomeDictionary.hasType((RegistryKey)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL) || BiomeDictionary.hasType((RegistryKey)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) || BiomeDictionary.hasType((RegistryKey)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY) ? 0.2f : 0.01f) > rand.nextFloat();
                        if (0.3 > (double)rand.nextFloat() && MathHelper.func_203301_d((float)(sign.getPointingYaw(true) + 180.0f), (float)yaw) > 70.0f) {
                            BlockPos stonePos = pos.func_177977_b().func_177971_a(backDir.func_176730_m());
                            if (rand.nextBoolean()) {
                                world.func_180501_a(stonePos, stoneSlab, 2);
                            } else {
                                world.func_180501_a(stonePos, (BlockState)stair.func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)sideDir), 2);
                            }
                            stonePos = stonePos.func_177971_a(sideDir.func_176730_m());
                            world.func_180501_a(stonePos, stone, 2);
                            if (0.35 > (double)rand.nextFloat()) {
                                world.func_180501_a(stonePos.func_177984_a(), hasFirefly ? jar : lanternDown, 3);
                                hasGroundLantern = true;
                            }
                            if (!RoadSignFeature.isNotSolid((IWorld)world, (stonePos = stonePos.func_177971_a(sideDir.func_176730_m())).func_177977_b())) {
                                if (rand.nextBoolean()) {
                                    world.func_180501_a(stonePos, stoneSlab, 2);
                                } else {
                                    world.func_180501_a(stonePos, (BlockState)stair.func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)sideDir.func_176734_d()), 2);
                                }
                            }
                        }
                        if (!hasGroundLantern) {
                            boolean doubleSided;
                            pos = pos.func_177981_b(2);
                            BlockState light = hasFirefly ? jar : lantern;
                            Direction dir = (Direction)lampDir.get(rand.nextInt(lampDir.size()));
                            boolean bl2 = doubleSided = 0.25 > (double)rand.nextFloat();
                            if (doubleSided) {
                                dir = dir.func_176746_e();
                            }
                            if (0.32 > (double)rand.nextFloat()) {
                                topState = 0.32 > (double)rand.nextFloat() ? trapdoor : air;
                                EnhancedLanternBlock wl = (EnhancedLanternBlock)ModRegistry.WALL_LANTERN.get();
                                wl.placeOn(lanternDown, pos.func_177977_b(), dir, (World)world);
                                if (doubleSided) {
                                    wl.placeOn(lanternDown, pos.func_177977_b(), dir.func_176734_d(), (World)world);
                                }
                            } else {
                                boolean isTrapdoor;
                                boolean bl3 = isTrapdoor = 0.4 > (double)rand.nextFloat();
                                if (!isTrapdoor) {
                                    topState = fence;
                                }
                                if (doubleSided) {
                                    BlockPos backPos = pos.func_177972_a(dir.func_176734_d());
                                    world.func_180501_a(backPos, isTrapdoor ? trapdoor : fence, 2);
                                    if (0.25 > (double)rand.nextFloat()) {
                                        topState = isTrapdoor ? slab : log;
                                    }
                                    world.func_180501_a(backPos.func_177977_b(), light, 3);
                                }
                                pos = pos.func_177972_a(dir);
                                BlockState frontState = isTrapdoor ? trapdoor : fence;
                                world.func_180501_a(pos, frontState, 2);
                                world.func_180501_a(pos.func_177977_b(), light, 3);
                            }
                        }
                    }
                } else {
                    ItemStack book = new ItemStack((IItemProvider)Items.field_151099_bA);
                    CompoundNBT com = new CompoundNBT();
                    ListNBT listnbt = new ListNBT();
                    listnbt.add((Object)StringNBT.func_229705_a_((String)"nothing here but monsters\n\n\n"));
                    com.func_218657_a("pages", (INBT)listnbt);
                    book.func_77982_d(com);
                    this.field_145850_b.func_180501_a(this.field_174879_c.func_177979_c(2), (BlockState)((BlockState)((Block)ModRegistry.NOTICE_BOARD.get()).func_176223_P().func_206870_a((Property)NoticeBoardBlock.HAS_BOOK, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)NoticeBoardBlock.FACING, (Comparable)Direction.Plane.HORIZONTAL.func_179518_a(this.func_145831_w().field_73012_v)), 3);
                    TileEntity te = world.func_175625_s(this.field_174879_c.func_177979_c(2));
                    if (te instanceof NoticeBoardBlockTile) {
                        ((ItemDisplayTile)te).setDisplayedItem(book);
                    }
                }
                world.func_180501_a(this.field_174879_c, topState, 3);
            }
            catch (Exception exception) {
                this.field_145850_b.func_217377_a(this.field_174879_c, false);
                Supplementaries.LOGGER.warn("failed to generate road sign at " + this.field_174879_c.toString() + ": " + exception);
            }
        }
    }

    private static ITextComponent getSignText(int d) {
        int s = d < 100 ? 10 : (d < 2000 ? 100 : 1000);
        return new TranslationTextComponent("message.supplementaries.road_sign", new Object[]{(d + s / 2) / s * s});
    }

    private static void replaceCobbleWithPath(World world, BlockPos pos, BlockState path) {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                BlockPos pathPos;
                BlockState state;
                if (Math.abs(i) == 2 && Math.abs(j) == 2 || i == 0 && j == 0 || !(state = world.func_180495_p(pathPos = pos.func_177982_a(i, -2, j))).func_203425_a(Blocks.field_150347_e) && !state.func_203425_a(Blocks.field_150341_Y)) continue;
                world.func_180501_a(pathPos, path, 2);
            }
        }
    }
}

