/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.mehvahdjukaar.supplementaries.block.blocks.RopeBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.SackBlockTile;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SackBlock
extends FallingBlock {
    public static final VoxelShape SHAPE_CLOSED = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0), Block.func_208617_a((double)5.0, (double)13.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0)});
    public static final VoxelShape SHAPE_OPEN = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0), Block.func_208617_a((double)3.0, (double)13.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0)});
    public static final ResourceLocation CONTENTS = new ResourceLocation("contents");
    public static final BooleanProperty OPEN = BlockStateProperties.field_208193_t;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public SackBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public int func_189876_x(BlockState state, IBlockReader reader, BlockPos pos) {
        return 12226410;
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.func_177230_c() != oldState.func_177230_c()) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, this.func_230329_c_());
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{OPEN, WATERLOGGED});
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean flag = context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        return (BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public static boolean canFall(BlockPos pos, IWorld world) {
        return (world.func_175623_d(pos.func_177977_b()) || SackBlock.func_185759_i((BlockState)world.func_180495_p(pos.func_177977_b()))) && pos.func_177956_o() >= 0 && !RopeBlock.isSupportingCeiling(pos.func_177984_a(), (IWorldReader)world);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof SackBlockTile) {
            SackBlockTile te = (SackBlockTile)tileentity;
            te.barrelTick();
            if (SackBlock.canFall(pos, (IWorld)worldIn)) {
                FallingBlockEntity fallingblockentity = new FallingBlockEntity((World)worldIn, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, worldIn.func_180495_p(pos)){

                    public ItemEntity func_199702_a(IItemProvider itemIn, int offset) {
                        ItemStack stack = new ItemStack(itemIn);
                        if (itemIn instanceof Block && ((Block)itemIn).func_176223_P().hasTileEntity()) {
                            stack.func_77983_a("BlockEntityTag", (INBT)this.field_145810_d);
                        }
                        return this.func_70099_a(stack, offset);
                    }

                    public boolean func_225503_b_(float distance, float damageMultiplier) {
                        int i = MathHelper.func_76123_f((float)(distance - 1.0f));
                        if (i > 0) {
                            ArrayList list = Lists.newArrayList((Iterable)this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ()));
                            DamageSource damagesource = DamageSource.field_82729_p;
                            for (Entity entity2 : list) {
                                entity2.func_70097_a(damagesource, (float)Math.min(MathHelper.func_76141_d((float)((float)i * 1.0f)), 20));
                            }
                        }
                        return false;
                    }
                };
                CompoundNBT com = new CompoundNBT();
                te.func_189515_b(com);
                fallingblockentity.field_145810_d = com;
                this.func_149829_a(fallingblockentity);
                worldIn.func_217376_c((Entity)fallingblockentity);
            }
        }
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new SackBlockTile();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (player.func_175149_v()) {
            return ActionResultType.CONSUME;
        }
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof SackBlockTile) {
            player.func_213829_a((INamedContainerProvider)tileentity);
            PiglinTasks.func_234478_a_((PlayerEntity)player, (boolean)true);
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof SackBlockTile) {
            SackBlockTile sack = (SackBlockTile)tileentity;
            if (!worldIn.field_72995_K && player.func_184812_l_() && !sack.func_191420_l()) {
                CompoundNBT compoundnbt = sack.saveToTag(new CompoundNBT());
                ItemStack itemstack = new ItemStack((IItemProvider)this.getBlock());
                if (!compoundnbt.isEmpty()) {
                    itemstack.func_77983_a("BlockEntityTag", (INBT)compoundnbt);
                }
                if (sack.func_145818_k_()) {
                    itemstack.func_200302_a(sack.func_200201_e());
                }
                ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, itemstack);
                itementity.func_174869_p();
                worldIn.func_217376_c((Entity)itementity);
            } else {
                sack.func_184281_d(player);
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity tileentity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (tileentity instanceof SackBlockTile) {
            SackBlockTile sack = (SackBlockTile)tileentity;
            builder = builder.func_216017_a(CONTENTS, (context, stackConsumer) -> {
                for (int i = 0; i < sack.func_70302_i_(); ++i) {
                    stackConsumer.accept(sack.func_70301_a(i));
                }
            });
        }
        return super.func_220076_a(state, builder);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        CompoundNBT compoundnbt;
        ItemStack itemstack = super.getPickBlock(state, target, world, pos, player);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof SackBlockTile && !(compoundnbt = ((SackBlockTile)te).saveToTag(new CompoundNBT())).isEmpty()) {
            itemstack.func_77983_a("BlockEntityTag", (INBT)compoundnbt);
        }
        return itemstack;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof SackBlockTile) {
            ((LockableTileEntity)tileentity).func_213903_a(stack.func_200301_q());
        }
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (((Boolean)state.func_177229_b((Property)OPEN)).booleanValue()) {
            return SHAPE_OPEN;
        }
        return SHAPE_CLOSED;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof SackBlockTile) {
                worldIn.func_175666_e(pos, state.func_177230_c());
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof SackBlockTile) {
            SackBlockTile sack = (SackBlockTile)tile;
            int i = 0;
            float f = 0.0f;
            int slots = sack.getUnlockedSlots();
            for (int j = 0; j < slots; ++j) {
                ItemStack itemstack = sack.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                f += (float)itemstack.func_190916_E() / (float)Math.min(sack.func_70297_j_(), itemstack.func_77976_d());
                ++i;
            }
            return MathHelper.func_76141_d((float)((f /= (float)slots) * 14.0f)) + (i > 0 ? 1 : 0);
        }
        return 0;
    }

    public INamedContainerProvider func_220052_b(BlockState state, World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity instanceof INamedContainerProvider ? (INamedContainerProvider)tileentity : null;
    }
}

