/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.util;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import me.lucko.spark.common.sampler.node.StackTraceNode;
import me.lucko.spark.common.sampler.node.ThreadNode;
import me.lucko.spark.common.util.ClassFinder;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface ClassSourceLookup {
    public static final ClassSourceLookup NO_OP = new ClassSourceLookup(){

        @Override
        public @Nullable String identify(Class<?> clazz) {
            return null;
        }
    };

    public @Nullable String identify(Class<?> var1) throws Exception;

    public static Visitor createVisitor(ClassSourceLookup lookup) {
        if (lookup == NO_OP) {
            return NoOpVistitor.INSTANCE;
        }
        return new VisitorImpl(lookup);
    }

    public static class VisitorImpl
    implements Visitor {
        private final ClassSourceLookup lookup;
        private final ClassFinder classFinder = new ClassFinder();
        private final Map<String, String> map = new HashMap<String, String>();

        VisitorImpl(ClassSourceLookup lookup) {
            this.lookup = lookup;
        }

        @Override
        public void visit(ThreadNode node) {
            for (StackTraceNode child : node.getChildren()) {
                this.visitStackNode(child);
            }
        }

        @Override
        public boolean hasMappings() {
            return !this.map.isEmpty();
        }

        @Override
        public Map<String, String> getMapping() {
            this.map.values().removeIf(Objects::isNull);
            return this.map;
        }

        private void visitStackNode(StackTraceNode node) {
            String className = node.getClassName();
            if (!this.map.containsKey(className)) {
                try {
                    Class<?> clazz = this.classFinder.findClass(className);
                    Objects.requireNonNull(clazz);
                    this.map.put(className, this.lookup.identify(clazz));
                }
                catch (Throwable e) {
                    this.map.put(className, null);
                }
            }
            for (StackTraceNode child : node.getChildren()) {
                this.visitStackNode(child);
            }
        }
    }

    public static enum NoOpVistitor implements Visitor
    {
        INSTANCE;


        @Override
        public void visit(ThreadNode node) {
        }

        @Override
        public boolean hasMappings() {
            return false;
        }

        @Override
        public Map<String, String> getMapping() {
            return Collections.emptyMap();
        }
    }

    public static interface Visitor {
        public void visit(ThreadNode var1);

        public boolean hasMappings();

        public Map<String, String> getMapping();
    }

    public static class ByCodeSource
    implements ClassSourceLookup {
        @Override
        public @Nullable String identify(Class<?> clazz) throws URISyntaxException {
            ProtectionDomain protectionDomain = clazz.getProtectionDomain();
            if (protectionDomain == null) {
                return null;
            }
            CodeSource codeSource = protectionDomain.getCodeSource();
            if (codeSource == null) {
                return null;
            }
            URL url = codeSource.getLocation();
            return url == null ? null : this.identifyUrl(url);
        }

        protected String identifyUrl(URL url) throws URISyntaxException {
            return url.getProtocol().equals("file") ? this.identifyFile(Paths.get(url.toURI())) : null;
        }

        protected String identifyFile(Path path) {
            return this.identifyFileName(path.getFileName().toString());
        }

        protected String identifyFileName(String fileName) {
            return fileName.endsWith(".jar") ? fileName.substring(0, fileName.length() - 4) : null;
        }
    }

    public static class ByFirstUrlSource
    extends ByClassLoader {
        @Override
        public @Nullable String identify(ClassLoader loader) throws IOException, URISyntaxException {
            if (loader instanceof URLClassLoader) {
                URLClassLoader urlClassLoader = (URLClassLoader)loader;
                URL[] urls = urlClassLoader.getURLs();
                if (urls.length == 0) {
                    return null;
                }
                return this.identifyUrl(urls[0]);
            }
            return null;
        }

        protected String identifyUrl(URL url) throws URISyntaxException {
            return url.getProtocol().equals("file") ? this.identifyFile(Paths.get(url.toURI())) : null;
        }

        protected String identifyFile(Path path) {
            return this.identifyFileName(path.getFileName().toString());
        }

        protected String identifyFileName(String fileName) {
            return fileName.endsWith(".jar") ? fileName.substring(0, fileName.length() - 4) : null;
        }
    }

    public static abstract class ByClassLoader
    implements ClassSourceLookup {
        public abstract @Nullable String identify(ClassLoader var1) throws Exception;

        @Override
        public final @Nullable String identify(Class<?> clazz) throws Exception {
            for (ClassLoader loader = clazz.getClassLoader(); loader != null; loader = loader.getParent()) {
                String source = this.identify(loader);
                if (source == null) continue;
                return source;
            }
            return null;
        }
    }
}

