/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.command.modules;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.zip.GZIPOutputStream;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.activitylog.Activity;
import me.lucko.spark.common.command.Arguments;
import me.lucko.spark.common.command.Command;
import me.lucko.spark.common.command.CommandModule;
import me.lucko.spark.common.command.CommandResponseHandler;
import me.lucko.spark.common.command.sender.CommandSender;
import me.lucko.spark.common.command.tabcomplete.TabCompleter;
import me.lucko.spark.common.heapdump.HeapDump;
import me.lucko.spark.common.heapdump.HeapDumpSummary;
import me.lucko.spark.common.util.FormatUtil;
import me.lucko.spark.lib.adventure.text.Component;
import me.lucko.spark.lib.adventure.text.TextComponent;
import me.lucko.spark.lib.adventure.text.event.ClickEvent;
import me.lucko.spark.lib.adventure.text.format.NamedTextColor;
import me.lucko.spark.lib.adventure.text.format.TextColor;
import me.lucko.spark.lib.okhttp3.MediaType;
import me.lucko.spark.lib.xz.LZMA2Options;
import me.lucko.spark.lib.xz.LZMAOutputStream;
import me.lucko.spark.lib.xz.XZOutputStream;

public class HeapAnalysisModule
implements CommandModule {
    private static final MediaType SPARK_HEAP_MEDIA_TYPE = MediaType.parse("application/x-spark-heap");

    @Override
    public void registerCommands(Consumer<Command> consumer) {
        consumer.accept(Command.builder().aliases("heapsummary").argumentUsage("run-gc-before", null).executor(HeapAnalysisModule::heapSummary).tabCompleter((platform, sender, arguments) -> TabCompleter.completeForOpts(arguments, "--run-gc-before")).build());
        consumer.accept(Command.builder().aliases("heapdump").argumentUsage("compress", "type").executor(HeapAnalysisModule::heapDump).tabCompleter((platform, sender, arguments) -> TabCompleter.completeForOpts(arguments, "--compress", "--run-gc-before", "--include-non-live")).build());
    }

    private static void heapSummary(SparkPlatform platform, CommandSender sender, CommandResponseHandler resp, Arguments arguments) {
        HeapDumpSummary heapDump;
        if (arguments.boolFlag("run-gc-before")) {
            resp.broadcastPrefixed(Component.text("Running garbage collector..."));
            System.gc();
        }
        resp.broadcastPrefixed(Component.text("Creating a new heap dump summary, please wait..."));
        try {
            heapDump = HeapDumpSummary.createNew();
        }
        catch (Exception e) {
            resp.broadcastPrefixed(Component.text("An error occurred whilst inspecting the heap.", (TextColor)NamedTextColor.RED));
            e.printStackTrace();
            return;
        }
        byte[] output = heapDump.formCompressedDataPayload(platform.getPlugin().getPlatformInfo(), sender);
        try {
            String key = SparkPlatform.BYTEBIN_CLIENT.postContent(output, SPARK_HEAP_MEDIA_TYPE).key();
            String url = "https://spark.lucko.me/" + key;
            resp.broadcastPrefixed(Component.text("Heap dump summmary output:", (TextColor)NamedTextColor.GOLD));
            resp.broadcast((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(url).color(NamedTextColor.GRAY)).clickEvent(ClickEvent.openUrl(url))).build());
            platform.getActivityLog().addToLog(Activity.urlActivity(sender, System.currentTimeMillis(), "Heap dump summary", url));
        }
        catch (IOException e) {
            resp.broadcastPrefixed(Component.text("An error occurred whilst uploading the data.", (TextColor)NamedTextColor.RED));
            e.printStackTrace();
        }
    }

    private static void heapDump(SparkPlatform platform, CommandSender sender, CommandResponseHandler resp, Arguments arguments) {
        boolean liveOnly;
        Path pluginFolder = platform.getPlugin().getPluginDirectory();
        try {
            Files.createDirectories(pluginFolder, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Path file = pluginFolder.resolve("heap-" + DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss").format(LocalDateTime.now()) + (HeapDump.isOpenJ9() ? ".phd" : ".hprof"));
        boolean bl = liveOnly = !arguments.boolFlag("include-non-live");
        if (arguments.boolFlag("run-gc-before")) {
            resp.broadcastPrefixed(Component.text("Running garbage collector..."));
            System.gc();
        }
        resp.broadcastPrefixed(Component.text("Creating a new heap dump, please wait..."));
        try {
            HeapDump.dumpHeap(file, liveOnly);
        }
        catch (Exception e) {
            resp.broadcastPrefixed(Component.text("An error occurred whilst creating a heap dump.", (TextColor)NamedTextColor.RED));
            e.printStackTrace();
            return;
        }
        resp.broadcastPrefixed((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("Heap dump written to: ").color(NamedTextColor.GOLD)).append((Component)Component.text(file.toString(), (TextColor)NamedTextColor.GRAY))).build());
        platform.getActivityLog().addToLog(Activity.fileActivity(sender, System.currentTimeMillis(), "Heap dump", file.toString()));
        CompressionMethod compressionMethod = null;
        Iterator<String> compressArgs = arguments.stringFlag("compress").iterator();
        if (compressArgs.hasNext()) {
            try {
                compressionMethod = CompressionMethod.valueOf(compressArgs.next().toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (compressionMethod != null) {
            try {
                HeapAnalysisModule.heapDumpCompress(platform, resp, file, compressionMethod);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void heapDumpCompress(SparkPlatform platform, CommandResponseHandler resp, Path file, CompressionMethod method) throws IOException {
        resp.broadcastPrefixed(Component.text("Compressing heap dump, please wait..."));
        long size = Files.size(file);
        AtomicLong lastReport = new AtomicLong(System.currentTimeMillis());
        LongConsumer progressHandler = progress -> {
            long timeSinceLastReport = System.currentTimeMillis() - lastReport.get();
            if (timeSinceLastReport > TimeUnit.SECONDS.toMillis(5L)) {
                lastReport.set(System.currentTimeMillis());
                platform.getPlugin().executeAsync(() -> resp.broadcastPrefixed((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color(NamedTextColor.GRAY)).append((Component)Component.text("Compressed "))).append((Component)Component.text(FormatUtil.formatBytes(progress), (TextColor)NamedTextColor.GOLD))).append((Component)Component.text(" / "))).append((Component)Component.text(FormatUtil.formatBytes(size), (TextColor)NamedTextColor.GOLD))).append((Component)Component.text(" so far... ("))).append((Component)Component.text(FormatUtil.percent(progress, size), (TextColor)NamedTextColor.GREEN))).append((Component)Component.text(")"))).build()));
            }
        };
        Path compressedFile = method.compress(file, progressHandler);
        long compressedSize = Files.size(compressedFile);
        resp.broadcastPrefixed((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color(NamedTextColor.GRAY)).append((Component)Component.text("Compression complete: "))).append((Component)Component.text(FormatUtil.formatBytes(size), (TextColor)NamedTextColor.GOLD))).append((Component)Component.text(" --> "))).append((Component)Component.text(FormatUtil.formatBytes(compressedSize), (TextColor)NamedTextColor.GOLD))).append((Component)Component.text(" ("))).append((Component)Component.text(FormatUtil.percent(compressedSize, size), (TextColor)NamedTextColor.GREEN))).append((Component)Component.text(")"))).build());
        resp.broadcastPrefixed((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("Compressed heap dump written to: ").color(NamedTextColor.GOLD)).append((Component)Component.text(compressedFile.toString(), (TextColor)NamedTextColor.GRAY))).build());
    }

    public static enum CompressionMethod {
        GZIP{

            @Override
            public Path compress(Path file, LongConsumer progressHandler) throws IOException {
                Path compressedFile = file.getParent().resolve(file.getFileName().toString() + ".gz");
                try (InputStream in = Files.newInputStream(file, new OpenOption[0]);
                     OutputStream out = Files.newOutputStream(compressedFile, new OpenOption[0]);
                     GZIPOutputStream compressionOut = new GZIPOutputStream(out, 65536);){
                    CompressionMethod.copy(in, compressionOut, progressHandler);
                }
                return compressedFile;
            }
        }
        ,
        XZ{

            @Override
            public Path compress(Path file, LongConsumer progressHandler) throws IOException {
                Path compressedFile = file.getParent().resolve(file.getFileName().toString() + ".xz");
                try (InputStream in = Files.newInputStream(file, new OpenOption[0]);
                     OutputStream out = Files.newOutputStream(compressedFile, new OpenOption[0]);
                     XZOutputStream compressionOut = new XZOutputStream(out, new LZMA2Options());){
                    CompressionMethod.copy(in, compressionOut, progressHandler);
                }
                return compressedFile;
            }
        }
        ,
        LZMA{

            @Override
            public Path compress(Path file, LongConsumer progressHandler) throws IOException {
                Path compressedFile = file.getParent().resolve(file.getFileName().toString() + ".lzma");
                try (InputStream in = Files.newInputStream(file, new OpenOption[0]);
                     OutputStream out = Files.newOutputStream(compressedFile, new OpenOption[0]);
                     LZMAOutputStream compressionOut = new LZMAOutputStream(out, new LZMA2Options(), true);){
                    CompressionMethod.copy(in, compressionOut, progressHandler);
                }
                return compressedFile;
            }
        };


        public abstract Path compress(Path var1, LongConsumer var2) throws IOException;

        private static long copy(InputStream from, OutputStream to, LongConsumer progress) throws IOException {
            int r;
            byte[] buf = new byte[65536];
            long total = 0L;
            long iterations = 0L;
            while ((r = from.read(buf)) != -1) {
                to.write(buf, 0, r);
                total += (long)r;
                if (iterations++ % 80L != 0L) continue;
                progress.accept(total);
            }
            return total;
        }
    }
}

