/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import dev.ftb.mods.ftbteams.data.ClientTeamManager;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamBase;
import dev.ftb.mods.ftbteams.data.TeamRank;
import dev.ftb.mods.ftbteams.data.TeamType;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;

public class ClientTeam
extends TeamBase {
    public final ClientTeamManager manager;
    public boolean invalid;
    TeamType type;

    public ClientTeam(ClientTeamManager m, PacketBuffer buffer, long now) {
        this.manager = m;
        this.id = buffer.func_179253_g();
        this.type = TeamType.VALUES[buffer.readByte()];
        this.properties.read(buffer);
        int rs = buffer.func_150792_a();
        for (int i = 0; i < rs; ++i) {
            this.ranks.put(buffer.func_179253_g(), TeamRank.VALUES[buffer.readByte()]);
        }
        this.extraData = buffer.func_150793_b();
    }

    public ClientTeam(ClientTeamManager m, Team team) {
        this.manager = m;
        this.id = team.getId();
        this.type = team.getType();
        this.properties.updateFrom(team.properties);
        this.ranks.putAll(team.ranks);
        this.extraData = team.extraData == null ? null : team.extraData.func_74737_b();
    }

    @Override
    public TeamType getType() {
        return this.type;
    }

    @Override
    public boolean isValid() {
        return this.manager.teamMap.containsKey(this.id);
    }

    public void write(PacketBuffer buffer, long now) {
        buffer.func_179252_a(this.id);
        buffer.writeByte(this.type.ordinal());
        this.properties.write(buffer);
        buffer.func_150787_b(this.ranks.size());
        for (Map.Entry entry : this.ranks.entrySet()) {
            buffer.func_179252_a((UUID)entry.getKey());
            buffer.writeByte(((TeamRank)((Object)entry.getValue())).ordinal());
        }
        buffer.func_150786_a(this.extraData);
    }

    public boolean isSelf() {
        return this == this.manager.selfTeam;
    }
}

