/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.TextBox;
import dev.ftb.mods.ftblibrary.ui.TextField;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.misc.NordColors;
import dev.ftb.mods.ftbteams.client.CreatePartyButton;
import dev.ftb.mods.ftbteams.client.MemberButton;
import dev.ftb.mods.ftbteams.data.ClientTeamManager;
import dev.ftb.mods.ftbteams.data.FTBTUtils;
import dev.ftb.mods.ftbteams.data.KnownClientPlayer;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamMessage;
import dev.ftb.mods.ftbteams.data.TeamRank;
import dev.ftb.mods.ftbteams.data.TeamType;
import dev.ftb.mods.ftbteams.net.OpenMyTeamGUIMessage;
import dev.ftb.mods.ftbteams.net.SendMessageMessage;
import dev.ftb.mods.ftbteams.net.UpdateSettingsMessage;
import dev.ftb.mods.ftbteams.property.TeamProperties;
import dev.ftb.mods.ftbteams.property.TeamProperty;
import dev.ftb.mods.ftbteams.property.TeamPropertyValue;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class MyTeamScreen
extends BaseScreen
implements NordColors {
    public final ClientTeamManager manager = Objects.requireNonNull(ClientTeamManager.INSTANCE);
    public final OpenMyTeamGUIMessage data;
    public Button settingsButton;
    public Button colorButton;
    public Panel memberPanel;
    public Panel chatPanel;
    public TextBox chatBox;

    public MyTeamScreen(OpenMyTeamGUIMessage res) {
        this.data = res;
        this.setSize(300, 200);
    }

    public void addWidgets() {
        this.settingsButton = new SimpleButton((Panel)this, (ITextComponent)new TranslationTextComponent("gui.settings"), Icon.getIcon((String)"ftbteams:textures/settings.png").withTint(SNOW_STORM_2), (simpleButton, mouseButton) -> {
            ConfigGroup config = new ConfigGroup("ftbteamsconfig");
            for (Map.Entry<TeamProperty, TeamPropertyValue> entry : this.data.properties.map.entrySet()) {
                entry.getKey().config(config, entry.getValue());
            }
            config.savedCallback = b -> {
                if (b) {
                    new UpdateSettingsMessage(this.data.properties).sendToServer();
                }
                this.openGui();
            };
            new EditConfigScreen(config).openGui();
        }){

            public void draw(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
                this.drawIcon(matrixStack, theme, x, y, w, h);
            }
        };
        this.add((Widget)this.settingsButton);
        this.colorButton = new SimpleButton((Panel)this, (ITextComponent)new TranslationTextComponent("gui.color"), this.data.properties.get(Team.COLOR).withBorder(POLAR_NIGHT_0, false), (simpleButton, mouseButton) -> {
            Color4I c = FTBTUtils.randomColor();
            this.data.properties.set(Team.COLOR, c);
            simpleButton.setIcon(c.withBorder(POLAR_NIGHT_0, false));
            TeamProperties properties = new TeamProperties();
            properties.set(Team.COLOR, c);
            new UpdateSettingsMessage(properties).sendToServer();
        }){

            public void draw(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
                this.icon.draw(matrixStack, x, y, w, h);
            }
        };
        this.add((Widget)this.colorButton);
        this.memberPanel = new Panel((Panel)this){

            public void addWidgets() {
                for (Map.Entry<UUID, TeamRank> entry : MyTeamScreen.this.manager.selfTeam.getRanked(TeamRank.NONE).entrySet()) {
                    KnownClientPlayer p = MyTeamScreen.this.manager.getKnownPlayer(entry.getKey());
                    if (p == null) continue;
                    this.add((Widget)new MemberButton(this, p, entry.getValue()));
                }
                if (MyTeamScreen.this.manager.selfTeam.getType() == TeamType.PLAYER) {
                    this.add((Widget)new CreatePartyButton(this));
                }
            }

            public void alignWidgets() {
                this.align((WidgetLayout)new WidgetLayout.Vertical(1, 2, 1));
                this.width = 80;
                for (Widget widget : this.widgets) {
                    this.width = Math.max(this.width, widget.width);
                }
                for (Widget widget : this.widgets) {
                    widget.setX(1);
                    widget.setWidth(this.width - 2);
                }
                MyTeamScreen.this.chatPanel.setPosAndSize(this.width + 3, 23, MyTeamScreen.this.width - MyTeamScreen.this.memberPanel.width - 5, MyTeamScreen.this.height - 40);
                MyTeamScreen.this.chatBox.setPosAndSize(MyTeamScreen.this.chatPanel.posX, MyTeamScreen.this.height - 15, MyTeamScreen.this.chatPanel.width, 13);
            }
        };
        this.add((Widget)this.memberPanel);
        this.chatPanel = new Panel((Panel)this){

            public void addWidgets() {
                UUID prev = null;
                for (TeamMessage message : MyTeamScreen.this.manager.selfTeam.messageHistory) {
                    if (!message.sender.equals(prev)) {
                        StringTextComponent name = new StringTextComponent("");
                        name.func_230529_a_(MyTeamScreen.this.manager.getName(message.sender));
                        name.func_240702_b_(":");
                        this.add((Widget)new TextField((Panel)this).setMaxWidth(this.width).setText((ITextComponent)name));
                        prev = message.sender;
                    }
                    this.add((Widget)new TextField((Panel)this).setMaxWidth(this.width).setText((ITextComponent)new StringTextComponent("  ").func_230529_a_(message.text)));
                }
                if (!this.widgets.isEmpty()) {
                    this.add((Widget)new TextField((Panel)this).setMaxWidth(this.width).setText(StringTextComponent.field_240750_d_));
                }
                this.add((Widget)new TextField((Panel)this).setMaxWidth(this.width).setText((ITextComponent)new StringTextComponent("This UI is WIP! Use /ftbteams for now!")));
            }

            public void alignWidgets() {
                this.align((WidgetLayout)new WidgetLayout.Vertical(2, 1, 1));
                this.movePanelScroll(0.0, this.getContentHeight());
            }

            public void drawBackground(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
                NordColors.POLAR_NIGHT_2.draw(matrixStack, x, y, w, h);
            }
        };
        this.add((Widget)this.chatPanel);
        this.chatBox = new TextBox((Panel)this){

            public void drawTextBox(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
                NordColors.POLAR_NIGHT_2.draw(matrixStack, x, y, w, h);
            }

            public void onEnterPressed() {
                new SendMessageMessage(this.getText()).sendToServer();
                this.setText("");
                this.setFocused(true);
            }
        };
        this.add((Widget)this.chatBox);
        this.settingsButton.setPosAndSize(this.width - 19, 4, 14, 14);
        this.colorButton.setPosAndSize(5, 5, 12, 12);
        this.memberPanel.setPosAndSize(1, 22, 89, this.height - 23);
    }

    public void drawBackground(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        GuiHelper.drawHollowRect((MatrixStack)matrixStack, (int)x, (int)y, (int)w, (int)h, (Color4I)POLAR_NIGHT_0, (boolean)true);
        POLAR_NIGHT_1.draw(matrixStack, x + 1, y + 1, w - 2, h - 2);
        POLAR_NIGHT_0.draw(matrixStack, x + 1, y + 21, w - 2, 1);
        POLAR_NIGHT_0.draw(matrixStack, x + this.memberPanel.width + 1, y + this.memberPanel.posY, 1, this.memberPanel.height);
    }

    public void drawForeground(MatrixStack matrixStack, Theme theme, int x, int y, int w, int h) {
        super.drawForeground(matrixStack, theme, x, y, w, h);
        theme.drawString(matrixStack, (Object)this.data.properties.get(Team.DISPLAY_NAME), (float)x + (float)w / 2.0f, (float)(y + 7), SNOW_STORM_1, 4);
    }
}

