/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.PriorityScreen;
import com.refinedmods.refinedstorage.screen.StorageScreenTileDataParameters;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.AccessTypeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.ExactModeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.RedstoneModeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.TypeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.WhitelistBlacklistSideButton;
import com.refinedmods.refinedstorage.util.RenderUtils;
import java.util.function.Supplier;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class StorageScreen<T extends Container>
extends BaseScreen<T> {
    private static final int BAR_X = 8;
    private static final int BAR_Y = 54;
    private static final int BAR_WIDTH = 16;
    private static final int BAR_HEIGHT = 70;
    private final String texture;
    private final StorageScreenTileDataParameters dataParameters;
    private final Supplier<Long> storedSupplier;
    private final Supplier<Long> capacitySupplier;

    public StorageScreen(T container, PlayerInventory inventory, ITextComponent title, String texture, StorageScreenTileDataParameters dataParameters, Supplier<Long> storedSupplier, Supplier<Long> capacitySupplier) {
        super(container, 176, 223, inventory, title);
        this.texture = texture;
        this.dataParameters = dataParameters;
        this.storedSupplier = storedSupplier;
        this.capacitySupplier = capacitySupplier;
    }

    @Override
    public void onPostInit(int x, int y) {
        if (this.dataParameters.getRedstoneModeParameter() != null) {
            this.addSideButton(new RedstoneModeSideButton(this, this.dataParameters.getRedstoneModeParameter()));
        }
        if (this.dataParameters.getTypeParameter() != null) {
            this.addSideButton(new TypeSideButton(this, this.dataParameters.getTypeParameter()));
        }
        if (this.dataParameters.getWhitelistBlacklistParameter() != null) {
            this.addSideButton(new WhitelistBlacklistSideButton(this, this.dataParameters.getWhitelistBlacklistParameter()));
        }
        if (this.dataParameters.getExactModeParameter() != null) {
            this.addSideButton(new ExactModeSideButton(this, this.dataParameters.getExactModeParameter()));
        }
        if (this.dataParameters.getAccessTypeParameter() != null) {
            this.addSideButton(new AccessTypeSideButton(this, this.dataParameters.getAccessTypeParameter()));
        }
        int buttonWidth = 10 + this.field_230712_o_.func_78256_a(I18n.func_135052_a((String)"misc.refinedstorage.priority", (Object[])new Object[0]));
        this.addButton(x + 169 - buttonWidth, y + 41, buttonWidth, 20, (ITextComponent)new TranslationTextComponent("misc.refinedstorage.priority"), true, true, btn -> this.field_230706_i_.func_147108_a((Screen)new PriorityScreen(this, this.dataParameters.getPriorityParameter(), this.field_213127_e)));
    }

    @Override
    public void tick(int x, int y) {
    }

    @Override
    public void renderBackground(MatrixStack matrixStack, int x, int y, int mouseX, int mouseY) {
        this.bindTexture("refinedstorage", this.texture);
        this.func_238474_b_(matrixStack, x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        int barHeightNew = this.capacitySupplier.get() < 0L ? 0 : (int)((float)this.storedSupplier.get().longValue() / (float)this.capacitySupplier.get().longValue() * 70.0f);
        this.func_238474_b_(matrixStack, x + 8, y + 54 + 70 - barHeightNew, 179, 70 - barHeightNew, 16, barHeightNew);
    }

    @Override
    public void renderForeground(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.renderString(matrixStack, 7, 7, this.field_230704_d_.getString());
        this.renderString(matrixStack, 7, 42, this.capacitySupplier.get() == -1L ? I18n.func_135052_a((String)"misc.refinedstorage.storage.stored_minimal", (Object[])new Object[]{API.instance().getQuantityFormatter().formatWithUnits(this.storedSupplier.get())}) : I18n.func_135052_a((String)"misc.refinedstorage.storage.stored_capacity_minimal", (Object[])new Object[]{API.instance().getQuantityFormatter().formatWithUnits(this.storedSupplier.get()), API.instance().getQuantityFormatter().formatWithUnits(this.capacitySupplier.get())}));
        this.renderString(matrixStack, 7, 129, I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]));
        if (RenderUtils.inBounds(8, 54, 16, 70, mouseX, mouseY)) {
            int full = 0;
            if (this.capacitySupplier.get() >= 0L) {
                full = (int)((float)this.storedSupplier.get().longValue() / (float)this.capacitySupplier.get().longValue() * 100.0f);
            }
            this.renderTooltip(matrixStack, mouseX, mouseY, (this.capacitySupplier.get() == -1L ? I18n.func_135052_a((String)"misc.refinedstorage.storage.stored_minimal", (Object[])new Object[]{API.instance().getQuantityFormatter().format(this.storedSupplier.get())}) : I18n.func_135052_a((String)"misc.refinedstorage.storage.stored_capacity_minimal", (Object[])new Object[]{API.instance().getQuantityFormatter().format(this.storedSupplier.get()), API.instance().getQuantityFormatter().format(this.capacitySupplier.get())})) + "\n" + TextFormatting.GRAY + I18n.func_135052_a((String)"misc.refinedstorage.storage.full", (Object[])new Object[]{full}));
        }
    }
}

