/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.apiimpl.network.node.SecurityManagerNetworkNode;
import com.refinedmods.refinedstorage.container.SecurityManagerContainer;
import com.refinedmods.refinedstorage.item.SecurityCardItem;
import com.refinedmods.refinedstorage.network.SecurityManagerUpdateMessage;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.widget.CheckboxWidget;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.RedstoneModeSideButton;
import com.refinedmods.refinedstorage.tile.NetworkNodeTile;
import com.refinedmods.refinedstorage.tile.SecurityManagerTile;
import com.refinedmods.refinedstorage.util.RenderUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class SecurityManagerScreen
extends BaseScreen<SecurityManagerContainer> {
    private final SecurityManagerTile securityManager;
    private final CheckboxWidget[] permissions = new CheckboxWidget[Permission.values().length];

    public SecurityManagerScreen(SecurityManagerContainer container, PlayerInventory inventory, ITextComponent title) {
        super(container, 176, 234, inventory, title);
        this.securityManager = (SecurityManagerTile)container.getTile();
    }

    @Override
    public void onPostInit(int x, int y) {
        this.addSideButton(new RedstoneModeSideButton(this, NetworkNodeTile.REDSTONE_MODE));
        int padding = 15;
        this.permissions[0] = this.addCheckBox(x + 7, y + 93, (ITextComponent)new TranslationTextComponent("gui.refinedstorage.security_manager.permission.0"), false, btn -> this.handle(0));
        this.permissions[1] = this.addCheckBox(this.permissions[0].field_230690_l_, this.permissions[0].field_230691_m_ + padding, (ITextComponent)new TranslationTextComponent("gui.refinedstorage.security_manager.permission.1"), false, btn -> this.handle(1));
        this.permissions[2] = this.addCheckBox(this.permissions[1].field_230690_l_, this.permissions[1].field_230691_m_ + padding, (ITextComponent)new TranslationTextComponent("gui.refinedstorage.security_manager.permission.2"), false, btn -> this.handle(2));
        this.permissions[3] = this.addCheckBox(this.permissions[0].field_230690_l_ + 90, this.permissions[0].field_230691_m_, (ITextComponent)new TranslationTextComponent("gui.refinedstorage.security_manager.permission.3"), false, btn -> this.handle(3));
        this.permissions[4] = this.addCheckBox(this.permissions[3].field_230690_l_, this.permissions[3].field_230691_m_ + padding, (ITextComponent)new TranslationTextComponent("gui.refinedstorage.security_manager.permission.4"), false, btn -> this.handle(4));
        this.permissions[5] = this.addCheckBox(this.permissions[4].field_230690_l_, this.permissions[4].field_230691_m_ + padding, (ITextComponent)new TranslationTextComponent("gui.refinedstorage.security_manager.permission.5"), false, btn -> this.handle(5));
    }

    private void handle(int i) {
        RS.NETWORK_HANDLER.sendToServer(new SecurityManagerUpdateMessage(this.securityManager.func_174877_v(), Permission.values()[i], this.permissions[i].func_212942_a()));
    }

    @Override
    public void tick(int x, int y) {
        ItemStack card = ((SecurityManagerNetworkNode)this.securityManager.getNode()).getEditCard().getStackInSlot(0);
        for (Permission permission : Permission.values()) {
            this.permissions[permission.getId()].setChecked(!card.func_190926_b() && SecurityCardItem.hasPermission(card, permission));
        }
    }

    @Override
    public void renderBackground(MatrixStack matrixStack, int x, int y, int mouseX, int mouseY) {
        this.bindTexture("refinedstorage", "gui/security_manager.png");
        this.func_238474_b_(matrixStack, x, y, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    @Override
    public void renderForeground(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.renderString(matrixStack, 7, 7, this.field_230704_d_.getString());
        this.renderString(matrixStack, 7, 59, I18n.func_135052_a((String)"gui.refinedstorage.security_manager.configure", (Object[])new Object[0]));
        this.renderString(matrixStack, 7, 140, I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]));
        for (int i = 0; i < this.permissions.length; ++i) {
            CheckboxWidget permission = this.permissions[i];
            if (!RenderUtils.inBounds(permission.field_230690_l_ - this.field_147003_i, permission.field_230691_m_ - this.field_147009_r, permission.func_230998_h_(), permission.func_238483_d_(), mouseX, mouseY)) continue;
            this.renderTooltip(matrixStack, mouseX, mouseY, I18n.func_135052_a((String)("gui.refinedstorage.security_manager.permission." + i + ".tooltip"), (Object[])new Object[0]));
        }
    }
}

