/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.render.model;

import com.refinedmods.refinedstorage.RSBlocks;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.Cover;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.refinedmods.refinedstorage.block.BaseBlock;
import com.refinedmods.refinedstorage.render.ConstantsCable;
import com.refinedmods.refinedstorage.render.model.CubeBuilder;
import com.refinedmods.refinedstorage.render.model.DelegateBakedModel;
import com.refinedmods.refinedstorage.util.RenderUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.data.IModelData;

public class BakedModelCableCover
extends DelegateBakedModel {
    private static TextureAtlasSprite BORDER_SPRITE;

    public BakedModelCableCover(IBakedModel base) {
        super(base);
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData data) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(this.base.getQuads(state, side, rand, data));
        if (data != null && data.hasProperty(CoverManager.PROPERTY)) {
            CoverManager manager = (CoverManager)data.getData(CoverManager.PROPERTY);
            BakedModelCableCover.addCover(quads, manager.getCover(Direction.NORTH), Direction.NORTH, side, rand, manager, state, true);
            BakedModelCableCover.addCover(quads, manager.getCover(Direction.SOUTH), Direction.SOUTH, side, rand, manager, state, true);
            BakedModelCableCover.addCover(quads, manager.getCover(Direction.EAST), Direction.EAST, side, rand, manager, state, true);
            BakedModelCableCover.addCover(quads, manager.getCover(Direction.WEST), Direction.WEST, side, rand, manager, state, true);
            BakedModelCableCover.addCover(quads, manager.getCover(Direction.DOWN), Direction.DOWN, side, rand, manager, state, true);
            BakedModelCableCover.addCover(quads, manager.getCover(Direction.UP), Direction.UP, side, rand, manager, state, true);
        }
        return quads;
    }

    private static int getHollowCoverSize(@Nullable BlockState state, Direction coverSide) {
        if (state == null) {
            return 6;
        }
        BaseBlock block = (BaseBlock)state.func_177230_c();
        if (block == RSBlocks.CABLE.get()) {
            return 6;
        }
        if (block.getDirection() != null && state.func_177229_b((Property)block.getDirection().getProperty()) == coverSide) {
            if (block == RSBlocks.EXPORTER.get()) {
                return 6;
            }
            if (block == RSBlocks.EXTERNAL_STORAGE.get() || block == RSBlocks.IMPORTER.get()) {
                return 3;
            }
            if (block == RSBlocks.CONSTRUCTOR.get() || block == RSBlocks.DESTRUCTOR.get()) {
                return 2;
            }
        }
        return 6;
    }

    protected static void addCover(List<BakedQuad> quads, @Nullable Cover cover, Direction coverSide, Direction side, Random rand, @Nullable CoverManager manager, BlockState state, boolean handle) {
        if (cover == null) {
            return;
        }
        BlockState coverState = CoverManager.getBlockState(cover.getStack());
        if (coverState == null) {
            return;
        }
        boolean hasUp = false;
        boolean hasDown = false;
        boolean hasEast = false;
        boolean hasWest = false;
        if (manager != null) {
            hasUp = manager.hasCover(Direction.UP);
            hasDown = manager.hasCover(Direction.DOWN);
            hasEast = manager.hasCover(Direction.EAST);
            hasWest = manager.hasCover(Direction.WEST);
        }
        switch (cover.getType()) {
            case NORMAL: {
                BakedModelCableCover.addNormalCover(quads, coverState, coverSide, hasUp, hasDown, hasEast, hasWest, handle, rand);
                break;
            }
            case HOLLOW: {
                BakedModelCableCover.addHollowCover(quads, coverState, coverSide, hasUp, hasDown, hasEast, hasWest, BakedModelCableCover.getHollowCoverSize(state, coverSide), rand);
            }
        }
    }

    private static void addNormalCover(List<BakedQuad> quads, BlockState state, Direction coverSide, boolean hasUp, boolean hasDown, boolean hasEast, boolean hasWest, boolean handle, Random random) {
        AxisAlignedBB bounds = ConstantsCable.getCoverBounds(coverSide);
        Vector3f from = new Vector3f((float)bounds.field_72340_a * 16.0f, (float)bounds.field_72338_b * 16.0f, (float)bounds.field_72339_c * 16.0f);
        Vector3f to = new Vector3f((float)bounds.field_72336_d * 16.0f, (float)bounds.field_72337_e * 16.0f, (float)bounds.field_72334_f * 16.0f);
        if (coverSide == Direction.NORTH) {
            if (hasWest) {
                from.setX(2.0f);
            }
            if (hasEast) {
                to.setX(14.0f);
            }
        } else if (coverSide == Direction.SOUTH) {
            if (hasWest) {
                from.setX(2.0f);
            }
            if (hasEast) {
                to.setX(14.0f);
            }
        }
        if (coverSide.func_176740_k() != Direction.Axis.Y) {
            if (hasDown) {
                from.setY(2.0f);
            }
            if (hasUp) {
                to.setY(14.0f);
            }
        }
        HashMap spriteCache = new HashMap();
        quads.addAll(new CubeBuilder().from(from.func_195899_a(), from.func_195900_b(), from.func_195902_c()).to(to.func_195899_a(), to.func_195900_b(), to.func_195902_c()).addFaces(face -> new CubeBuilder.Face((Direction)face, spriteCache.computeIfAbsent(face, direction -> RenderUtils.getSprite(Minecraft.func_71410_x().func_175602_ab().func_184389_a(state), state, direction, random)))).bake());
        if (handle) {
            if (BORDER_SPRITE == null) {
                BORDER_SPRITE = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(new ResourceLocation("refinedstorage", "block/cable_part_border"));
            }
            bounds = ConstantsCable.getHolderBounds(coverSide);
            from = new Vector3f((float)bounds.field_72340_a * 16.0f, (float)bounds.field_72338_b * 16.0f, (float)bounds.field_72339_c * 16.0f);
            to = new Vector3f((float)bounds.field_72336_d * 16.0f, (float)bounds.field_72337_e * 16.0f, (float)bounds.field_72334_f * 16.0f);
            quads.addAll(new CubeBuilder().from(from.func_195899_a(), from.func_195900_b(), from.func_195902_c()).to(to.func_195899_a(), to.func_195900_b(), to.func_195902_c()).addFaces(face -> new CubeBuilder.Face((Direction)face, BORDER_SPRITE)).bake());
        }
    }

    private static void addHollowCover(List<BakedQuad> quads, BlockState state, Direction coverSide, boolean hasUp, boolean hasDown, boolean hasEast, boolean hasWest, int size, Random random) {
        AxisAlignedBB bounds = ConstantsCable.getCoverBounds(coverSide);
        Vector3f from = new Vector3f((float)bounds.field_72340_a * 16.0f, (float)bounds.field_72338_b * 16.0f, (float)bounds.field_72339_c * 16.0f);
        Vector3f to = new Vector3f((float)bounds.field_72336_d * 16.0f, (float)bounds.field_72337_e * 16.0f, (float)bounds.field_72334_f * 16.0f);
        if (coverSide.func_176740_k() != Direction.Axis.Y) {
            if (hasDown) {
                from.setY(2.0f);
            }
            if (hasUp) {
                to.setY(14.0f);
            }
        }
        if (coverSide == Direction.NORTH) {
            if (hasWest) {
                from.setX(2.0f);
            } else {
                from.setX(0.0f);
            }
            to.setX((float)size);
        } else if (coverSide == Direction.SOUTH) {
            if (hasEast) {
                to.setX(14.0f);
            } else {
                to.setX(16.0f);
            }
            from.setX((float)(16 - size));
        } else if (coverSide == Direction.EAST) {
            from.setZ(0.0f);
            to.setZ((float)size);
        } else if (coverSide == Direction.WEST) {
            from.setZ((float)(16 - size));
            to.setZ(16.0f);
        } else if (coverSide == Direction.DOWN || coverSide == Direction.UP) {
            from.setZ((float)(16 - size));
            to.setZ(16.0f);
        }
        HashMap spriteCache = new HashMap();
        quads.addAll(new CubeBuilder().from(from.func_195899_a(), from.func_195900_b(), from.func_195902_c()).to(to.func_195899_a(), to.func_195900_b(), to.func_195902_c()).addFaces(face -> new CubeBuilder.Face((Direction)face, spriteCache.computeIfAbsent(face, direction -> RenderUtils.getSprite(Minecraft.func_71410_x().func_175602_ab().func_184389_a(state), state, direction, random)))).bake());
        if (coverSide == Direction.NORTH) {
            if (hasEast) {
                to.setX(14.0f);
            } else {
                to.setX(16.0f);
            }
            from.setX((float)(16 - size));
        } else if (coverSide == Direction.SOUTH) {
            if (hasWest) {
                from.setX(2.0f);
            } else {
                from.setX(0.0f);
            }
            to.setX((float)size);
        } else if (coverSide == Direction.EAST) {
            from.setZ((float)(16 - size));
            to.setZ(16.0f);
        } else if (coverSide == Direction.WEST) {
            from.setZ(0.0f);
            to.setZ((float)size);
        } else if (coverSide == Direction.DOWN || coverSide == Direction.UP) {
            from.setZ(0.0f);
            to.setZ((float)size);
        }
        quads.addAll(new CubeBuilder().from(from.func_195899_a(), from.func_195900_b(), from.func_195902_c()).to(to.func_195899_a(), to.func_195900_b(), to.func_195902_c()).addFaces(face -> new CubeBuilder.Face((Direction)face, spriteCache.computeIfAbsent(face, direction -> RenderUtils.getSprite(Minecraft.func_71410_x().func_175602_ab().func_184389_a(state), state, direction, random)))).bake());
        if (coverSide == Direction.NORTH) {
            from.setX((float)size);
            to.setX((float)(16 - size));
            if (hasDown) {
                from.setY(2.0f);
            } else {
                from.setY(0.0f);
            }
            to.setY((float)size);
        } else if (coverSide == Direction.SOUTH) {
            from.setX((float)size);
            to.setX((float)(16 - size));
            if (hasDown) {
                from.setY(2.0f);
            } else {
                from.setY(0.0f);
            }
            to.setY((float)size);
        } else if (coverSide == Direction.EAST) {
            from.setZ((float)size);
            to.setZ((float)(16 - size));
            if (hasDown) {
                from.setY(2.0f);
            } else {
                from.setY(0.0f);
            }
            to.setY((float)size);
        } else if (coverSide == Direction.WEST) {
            from.setZ((float)size);
            to.setZ((float)(16 - size));
            if (hasDown) {
                from.setY(2.0f);
            } else {
                from.setY(0.0f);
            }
            to.setY((float)size);
        } else if (coverSide == Direction.DOWN || coverSide == Direction.UP) {
            from.setZ((float)size);
            to.setZ((float)(16 - size));
            from.setX(0.0f);
            to.setX((float)size);
        }
        quads.addAll(new CubeBuilder().from(from.func_195899_a(), from.func_195900_b(), from.func_195902_c()).to(to.func_195899_a(), to.func_195900_b(), to.func_195902_c()).addFaces(face -> new CubeBuilder.Face((Direction)face, spriteCache.computeIfAbsent(face, direction -> RenderUtils.getSprite(Minecraft.func_71410_x().func_175602_ab().func_184389_a(state), state, direction, random)))).bake());
        if (coverSide == Direction.NORTH) {
            from.setX((float)size);
            to.setX((float)(16 - size));
            if (hasUp) {
                to.setY(14.0f);
            } else {
                to.setY(16.0f);
            }
            from.setY((float)(16 - size));
        } else if (coverSide == Direction.SOUTH) {
            from.setX((float)size);
            to.setX((float)(16 - size));
            if (hasUp) {
                to.setY(14.0f);
            } else {
                to.setY(16.0f);
            }
            from.setY((float)(16 - size));
        } else if (coverSide == Direction.EAST) {
            from.setZ((float)size);
            to.setZ((float)(16 - size));
            if (hasUp) {
                to.setY(14.0f);
            } else {
                to.setY(16.0f);
            }
            from.setY((float)(16 - size));
        } else if (coverSide == Direction.WEST) {
            from.setZ((float)size);
            to.setZ((float)(16 - size));
            if (hasUp) {
                to.setY(14.0f);
            } else {
                to.setY(16.0f);
            }
            from.setY((float)(16 - size));
        } else if (coverSide == Direction.DOWN || coverSide == Direction.UP) {
            from.setZ((float)size);
            to.setZ((float)(16 - size));
            from.setX((float)(16 - size));
            to.setX(16.0f);
        }
        quads.addAll(new CubeBuilder().from(from.func_195899_a(), from.func_195900_b(), from.func_195902_c()).to(to.func_195899_a(), to.func_195900_b(), to.func_195902_c()).addFaces(face -> new CubeBuilder.Face((Direction)face, spriteCache.computeIfAbsent(face, direction -> RenderUtils.getSprite(Minecraft.func_71410_x().func_175602_ab().func_184389_a(state), state, direction, random)))).bake());
    }
}

