/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.network.grid;

import com.refinedmods.refinedstorage.container.GridContainer;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class GridItemInventoryScrollMessage {
    private final int slot;
    private final boolean shift;
    private final boolean up;

    public GridItemInventoryScrollMessage(int slot, boolean shift, boolean up) {
        this.slot = slot;
        this.shift = shift;
        this.up = up;
    }

    public static GridItemInventoryScrollMessage decode(PacketBuffer buf) {
        return new GridItemInventoryScrollMessage(buf.readInt(), buf.readBoolean(), buf.readBoolean());
    }

    public static void encode(GridItemInventoryScrollMessage message, PacketBuffer buf) {
        buf.writeInt(message.slot);
        buf.writeBoolean(message.shift);
        buf.writeBoolean(message.up);
    }

    public static void handle(GridItemInventoryScrollMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && player.field_71070_bA instanceof GridContainer && ((GridContainer)player.field_71070_bA).getGrid().getItemHandler() != null) {
                ((GridContainer)player.field_71070_bA).getGrid().getItemHandler().onInventoryScroll(player, message.slot, message.shift, message.up);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

