/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.network;

import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.grid.factory.PortableGridGridFactory;
import com.refinedmods.refinedstorage.inventory.player.PlayerSlot;
import com.refinedmods.refinedstorage.item.NetworkItem;
import com.refinedmods.refinedstorage.item.blockitem.PortableGridBlockItem;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class OpenNetworkItemMessage {
    private final PlayerSlot slot;

    public OpenNetworkItemMessage(PlayerSlot slot) {
        this.slot = slot;
    }

    public static OpenNetworkItemMessage decode(PacketBuffer buf) {
        return new OpenNetworkItemMessage(new PlayerSlot(buf));
    }

    public static void encode(OpenNetworkItemMessage message, PacketBuffer buf) {
        message.slot.writePlayerSlot(buf);
    }

    public static void handle(OpenNetworkItemMessage message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity player = ctx.get().getSender();
        if (player != null) {
            ctx.get().enqueueWork(() -> {
                ItemStack stack = message.slot.getStackFromSlot((PlayerEntity)player);
                if (stack == null) {
                    return;
                }
                if (stack.func_77973_b() instanceof NetworkItem) {
                    ((NetworkItem)stack.func_77973_b()).applyNetwork(player.func_184102_h(), stack, n -> n.getNetworkItemManager().open((PlayerEntity)player, stack, message.slot), err -> player.func_145747_a(err, player.func_110124_au()));
                } else if (stack.func_77973_b() instanceof PortableGridBlockItem) {
                    API.instance().getGridManager().openGrid(PortableGridGridFactory.ID, player, stack, message.slot);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

