/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.item;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.RSItems;
import com.refinedmods.refinedstorage.api.storage.StorageType;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskProvider;
import com.refinedmods.refinedstorage.api.storage.disk.StorageDiskSyncData;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.storage.ItemStorageType;
import com.refinedmods.refinedstorage.item.StoragePartItem;
import com.refinedmods.refinedstorage.render.Styles;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class StorageDiskItem
extends Item
implements IStorageDiskProvider {
    private static final String NBT_ID = "Id";
    private final ItemStorageType type;

    public StorageDiskItem(ItemStorageType type) {
        super(new Item.Properties().func_200916_a(RS.MAIN_GROUP).func_200917_a(1));
        this.type = type;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        super.func_77663_a(stack, world, entity, slot, selected);
        if (!world.field_72995_K && !stack.func_77942_o() && entity instanceof PlayerEntity) {
            UUID id = UUID.randomUUID();
            API.instance().getStorageDiskManager((ServerWorld)world).set(id, API.instance().createDefaultItemDisk((ServerWorld)world, this.getCapacity(stack), (PlayerEntity)entity));
            API.instance().getStorageDiskManager((ServerWorld)world).markForSaving();
            this.setId(stack, id);
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (this.isValid(stack)) {
            UUID id = this.getId(stack);
            API.instance().getStorageDiskSync().sendRequest(id);
            StorageDiskSyncData data = API.instance().getStorageDiskSync().getData(id);
            if (data != null) {
                if (data.getCapacity() == -1) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("misc.refinedstorage.storage.stored", new Object[]{API.instance().getQuantityFormatter().format(data.getStored())}).func_230530_a_(Styles.GRAY));
                } else {
                    tooltip.add((ITextComponent)new TranslationTextComponent("misc.refinedstorage.storage.stored_capacity", new Object[]{API.instance().getQuantityFormatter().format(data.getStored()), API.instance().getQuantityFormatter().format(data.getCapacity())}).func_230530_a_(Styles.GRAY));
                }
            }
            if (flag.func_194127_a()) {
                tooltip.add((ITextComponent)new StringTextComponent(id.toString()).func_230530_a_(Styles.GRAY));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        IStorageDisk disk;
        ItemStack diskStack = player.func_184586_b(hand);
        if (!world.field_72995_K && player.func_213453_ef() && this.type != ItemStorageType.CREATIVE && (disk = API.instance().getStorageDiskManager((ServerWorld)world).getByStack(diskStack)) != null && disk.getStored() == 0) {
            ItemStack storagePart = new ItemStack((IItemProvider)StoragePartItem.getByType(this.type), diskStack.func_190916_E());
            if (!player.field_71071_by.func_70441_a(storagePart.func_77946_l())) {
                InventoryHelper.func_180173_a((World)world, (double)player.func_226277_ct_(), (double)player.func_226278_cu_(), (double)player.func_226281_cx_(), (ItemStack)storagePart);
            }
            API.instance().getStorageDiskManager((ServerWorld)world).remove(this.getId(diskStack));
            API.instance().getStorageDiskManager((ServerWorld)world).markForSaving();
            return new ActionResult(ActionResultType.SUCCESS, (Object)new ItemStack((IItemProvider)RSItems.STORAGE_HOUSING.get()));
        }
        return new ActionResult(ActionResultType.PASS, (Object)diskStack);
    }

    public int getEntityLifespan(ItemStack stack, World world) {
        return Integer.MAX_VALUE;
    }

    @Override
    public UUID getId(ItemStack disk) {
        return disk.func_77978_p().func_186857_a(NBT_ID);
    }

    @Override
    public void setId(ItemStack disk, UUID id) {
        disk.func_77982_d(new CompoundNBT());
        disk.func_77978_p().func_186854_a(NBT_ID, id);
    }

    @Override
    public boolean isValid(ItemStack disk) {
        return disk.func_77942_o() && disk.func_77978_p().func_186855_b(NBT_ID);
    }

    @Override
    public int getCapacity(ItemStack disk) {
        return this.type.getCapacity();
    }

    @Override
    public StorageType getType() {
        return StorageType.ITEM;
    }
}

