/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.integration.jei;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.grid.GridType;
import com.refinedmods.refinedstorage.container.GridContainer;
import com.refinedmods.refinedstorage.integration.jei.IngredientTracker;
import com.refinedmods.refinedstorage.integration.jei.RecipeTransferCraftingGridError;
import com.refinedmods.refinedstorage.integration.jei.RecipeTransferPatternGridError;
import com.refinedmods.refinedstorage.network.grid.GridCraftingPreviewRequestMessage;
import com.refinedmods.refinedstorage.network.grid.GridProcessingTransferMessage;
import com.refinedmods.refinedstorage.network.grid.GridTransferMessage;
import com.refinedmods.refinedstorage.screen.grid.GridScreen;
import com.refinedmods.refinedstorage.screen.grid.stack.IGridStack;
import com.refinedmods.refinedstorage.screen.grid.stack.ItemGridStack;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GridRecipeTransferHandler
implements IRecipeTransferHandler<GridContainer> {
    public static final GridRecipeTransferHandler INSTANCE = new GridRecipeTransferHandler();
    private static final long TRANSFER_SCROLLBAR_DELAY_MS = 200L;
    private long lastTransferTimeMs;

    private GridRecipeTransferHandler() {
    }

    public Class<GridContainer> getContainerClass() {
        return GridContainer.class;
    }

    public IRecipeTransferError transferRecipe(@Nonnull GridContainer container, Object recipe, @Nonnull IRecipeLayout recipeLayout, @Nonnull PlayerEntity player, boolean maxTransfer, boolean doTransfer) {
        if (!(container.getScreenInfoProvider() instanceof GridScreen)) {
            return null;
        }
        GridType type = container.getGrid().getGridType();
        if (type == GridType.CRAFTING) {
            return this.transferRecipeForCraftingGrid(container, recipeLayout, player, doTransfer);
        }
        if (type == GridType.PATTERN) {
            return this.transferRecipeForPatternGrid(container, recipeLayout, player, doTransfer);
        }
        return null;
    }

    private RecipeTransferCraftingGridError transferRecipeForCraftingGrid(GridContainer container, IRecipeLayout recipeLayout, PlayerEntity player, boolean doTransfer) {
        IngredientTracker tracker = this.createTracker(container, recipeLayout, player, doTransfer);
        if (doTransfer) {
            if (tracker.hasMissingButAutocraftingAvailable() && Screen.func_231172_r_()) {
                tracker.createCraftingRequests().forEach((id, count) -> RS.NETWORK_HANDLER.sendToServer(new GridCraftingPreviewRequestMessage((UUID)id, (int)count, Screen.func_231173_s_(), false)));
            } else {
                this.moveItems(container, recipeLayout, tracker);
            }
        } else if (tracker.hasMissing()) {
            return new RecipeTransferCraftingGridError(tracker);
        }
        return null;
    }

    private IRecipeTransferError transferRecipeForPatternGrid(GridContainer container, IRecipeLayout recipeLayout, PlayerEntity player, boolean doTransfer) {
        IngredientTracker tracker = this.createTracker(container, recipeLayout, player, doTransfer);
        if (doTransfer) {
            this.moveItems(container, recipeLayout, tracker);
        } else if (tracker.isAutocraftingAvailable()) {
            return new RecipeTransferPatternGridError(tracker);
        }
        return null;
    }

    private IngredientTracker createTracker(GridContainer container, IRecipeLayout recipeLayout, PlayerEntity player, boolean doTransfer) {
        CraftingInventory craftingMatrix;
        IngredientTracker tracker = new IngredientTracker(recipeLayout, doTransfer);
        Collection<IGridStack> gridStacks = ((GridScreen)container.getScreenInfoProvider()).getView().getAllStacks();
        if (container.getGrid().isGridActive()) {
            for (IGridStack gridStack : gridStacks) {
                if (!(gridStack instanceof ItemGridStack)) continue;
                tracker.addAvailableStack(((ItemGridStack)gridStack).getStack(), gridStack);
            }
        }
        for (int inventorySlot = 0; inventorySlot < player.field_71071_by.func_70302_i_(); ++inventorySlot) {
            if (player.field_71071_by.func_70301_a(inventorySlot).func_190926_b()) continue;
            tracker.addAvailableStack(player.field_71071_by.func_70301_a(inventorySlot), null);
        }
        if (container.getGrid().getGridType().equals((Object)GridType.CRAFTING) && (craftingMatrix = container.getGrid().getCraftingMatrix()) != null) {
            for (int matrixSlot = 0; matrixSlot < craftingMatrix.func_70302_i_(); ++matrixSlot) {
                if (craftingMatrix.func_70301_a(matrixSlot).func_190926_b()) continue;
                tracker.addAvailableStack(craftingMatrix.func_70301_a(matrixSlot), null);
            }
        }
        return tracker;
    }

    public boolean hasTransferredRecently() {
        return System.currentTimeMillis() - this.lastTransferTimeMs <= 200L;
    }

    private void moveItems(GridContainer gridContainer, IRecipeLayout recipeLayout, IngredientTracker tracker) {
        this.lastTransferTimeMs = System.currentTimeMillis();
        if (gridContainer.getGrid().getGridType() == GridType.PATTERN && !recipeLayout.getRecipeCategory().getUid().equals((Object)VanillaRecipeCategoryUid.CRAFTING)) {
            this.moveForProcessing(recipeLayout, tracker);
        } else {
            this.move(gridContainer, recipeLayout);
        }
    }

    private void move(GridContainer gridContainer, IRecipeLayout recipeLayout) {
        RS.NETWORK_HANDLER.sendToServer(new GridTransferMessage(recipeLayout.getItemStacks().getGuiIngredients(), gridContainer.field_75151_b.stream().filter(s -> s.field_75224_c instanceof CraftingInventory).collect(Collectors.toList())));
    }

    private void moveForProcessing(IRecipeLayout recipeLayout, IngredientTracker tracker) {
        LinkedList<ItemStack> inputs = new LinkedList<ItemStack>();
        LinkedList<ItemStack> outputs = new LinkedList<ItemStack>();
        LinkedList<FluidStack> fluidInputs = new LinkedList<FluidStack>();
        LinkedList<FluidStack> fluidOutputs = new LinkedList<FluidStack>();
        for (IGuiIngredient guiIngredient : recipeLayout.getItemStacks().getGuiIngredients().values()) {
            this.handleItemIngredient(inputs, outputs, (IGuiIngredient<ItemStack>)guiIngredient, tracker);
        }
        for (IGuiIngredient guiIngredient : recipeLayout.getFluidStacks().getGuiIngredients().values()) {
            this.handleFluidIngredient(fluidInputs, fluidOutputs, (IGuiIngredient<FluidStack>)guiIngredient);
        }
        RS.NETWORK_HANDLER.sendToServer(new GridProcessingTransferMessage(inputs, outputs, fluidInputs, fluidOutputs));
    }

    private void handleFluidIngredient(List<FluidStack> fluidInputs, List<FluidStack> fluidOutputs, IGuiIngredient<FluidStack> guiIngredient) {
        if (guiIngredient != null && guiIngredient.getDisplayedIngredient() != null) {
            FluidStack ingredient = ((FluidStack)guiIngredient.getDisplayedIngredient()).copy();
            if (guiIngredient.isInput()) {
                fluidInputs.add(ingredient);
            } else {
                fluidOutputs.add(ingredient);
            }
        }
    }

    private void handleItemIngredient(List<ItemStack> inputs, List<ItemStack> outputs, IGuiIngredient<ItemStack> guiIngredient, IngredientTracker tracker) {
        if (guiIngredient != null && guiIngredient.getDisplayedIngredient() != null) {
            ItemStack ingredient = tracker.findBestMatch(guiIngredient.getAllIngredients()).func_77946_l();
            if (ingredient == ItemStack.field_190927_a) {
                ingredient = ((ItemStack)guiIngredient.getDisplayedIngredient()).func_77946_l();
            }
            if (guiIngredient.isInput()) {
                inputs.add(ingredient);
            } else {
                outputs.add(ingredient);
            }
        }
    }
}

