/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.node;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.RSItems;
import com.refinedmods.refinedstorage.api.network.INetworkNodeVisitor;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.validator.ItemValidator;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.item.NetworkCardItem;
import com.refinedmods.refinedstorage.tile.NetworkReceiverTile;
import com.refinedmods.refinedstorage.util.StackUtils;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;

public class NetworkTransmitterNetworkNode
extends NetworkNode {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "network_transmitter");
    private final BaseItemHandler networkCard = new BaseItemHandler(1).addValidator(new ItemValidator((Item)RSItems.NETWORK_CARD.get())).addListener(new NetworkNodeInventoryListener(this)).addListener((handler, slot, reading) -> {
        ItemStack card = handler.getStackInSlot(slot);
        if (card.func_190926_b()) {
            this.receiver = null;
            this.receiverDimension = null;
        } else {
            this.receiver = NetworkCardItem.getReceiver(card);
            this.receiverDimension = NetworkCardItem.getDimension(card);
        }
        if (this.network != null) {
            this.network.getNodeGraph().invalidate(Action.PERFORM, this.network.getWorld(), this.network.getPosition());
        }
    });
    private BlockPos receiver;
    private RegistryKey<World> receiverDimension;

    public NetworkTransmitterNetworkNode(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public CompoundNBT write(CompoundNBT tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.networkCard, 0, tag);
        return tag;
    }

    @Override
    public void read(CompoundNBT tag) {
        super.read(tag);
        StackUtils.readItems(this.networkCard, 0, tag);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public int getEnergyUsage() {
        return RS.SERVER_CONFIG.getNetworkTransmitter().getUsage();
    }

    public BaseItemHandler getNetworkCard() {
        return this.networkCard;
    }

    @Override
    public IItemHandler getDrops() {
        return this.getNetworkCard();
    }

    @Nullable
    public RegistryKey<World> getReceiverDimension() {
        return this.receiverDimension;
    }

    public int getDistance() {
        if (this.receiver == null || this.receiverDimension == null || !this.isSameDimension()) {
            return -1;
        }
        return (int)Math.sqrt(Math.pow(this.pos.func_177958_n() - this.receiver.func_177958_n(), 2.0) + Math.pow(this.pos.func_177956_o() - this.receiver.func_177956_o(), 2.0) + Math.pow(this.pos.func_177952_p() - this.receiver.func_177952_p(), 2.0));
    }

    public boolean isSameDimension() {
        return this.world.func_234923_W_() == this.receiverDimension;
    }

    private boolean canTransmit() {
        return this.canUpdate() && this.receiver != null && this.receiverDimension != null;
    }

    @Override
    public boolean shouldRebuildGraphOnChange() {
        return true;
    }

    @Override
    public void visit(INetworkNodeVisitor.Operator operator) {
        super.visit(operator);
        if (this.canTransmit()) {
            if (!this.isSameDimension()) {
                ServerWorld dimensionWorld = this.world.func_73046_m().func_71218_a(this.receiverDimension);
                if (dimensionWorld != null && dimensionWorld.func_175625_s(this.receiver) instanceof NetworkReceiverTile) {
                    operator.apply((World)dimensionWorld, this.receiver, null);
                }
            } else if (this.world.func_175625_s(this.receiver) instanceof NetworkReceiverTile) {
                operator.apply(this.world, this.receiver, null);
            }
        }
    }
}

