/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6;

import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.api.util.IStackList;
import com.refinedmods.refinedstorage.api.util.StackListEntry;
import com.refinedmods.refinedstorage.apiimpl.API;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public final class IoUtil {
    private static final int DEFAULT_EXTRACT_FLAGS = 1;

    private IoUtil() {
    }

    public static IStackList<ItemStack> extractFromInternalItemStorage(IStackList<ItemStack> list, IStorageDisk<ItemStack> storage, Action action) {
        IStackList<ItemStack> extracted = API.instance().createItemStackList();
        for (StackListEntry<ItemStack> entry : list.getStacks()) {
            ItemStack result = storage.extract(entry.getStack(), entry.getStack().func_190916_E(), 1, action);
            if (result.func_190926_b() || result.func_190916_E() != entry.getStack().func_190916_E()) {
                if (action == Action.PERFORM) {
                    throw new IllegalStateException("The internal crafting inventory reported that " + entry.getStack() + " was available but we got " + result);
                }
                return null;
            }
            extracted.add(result);
        }
        return extracted;
    }

    public static IStackList<FluidStack> extractFromInternalFluidStorage(IStackList<FluidStack> list, IStorageDisk<FluidStack> storage, Action action) {
        IStackList<FluidStack> extracted = API.instance().createFluidStackList();
        for (StackListEntry<FluidStack> entry : list.getStacks()) {
            FluidStack result = storage.extract(entry.getStack(), entry.getStack().getAmount(), 1, action);
            if (result.isEmpty() || result.getAmount() != entry.getStack().getAmount()) {
                if (action == Action.PERFORM) {
                    throw new IllegalStateException("The internal crafting inventory reported that " + entry.getStack() + " was available but we got " + result);
                }
                return null;
            }
            extracted.add(result);
        }
        return extracted;
    }

    public static void extractItemsFromNetwork(IStackList<ItemStack> toExtractInitial, INetwork network, IStorageDisk<ItemStack> internalStorage) {
        if (toExtractInitial.isEmpty()) {
            return;
        }
        ArrayList<ItemStack> toRemove = new ArrayList<ItemStack>();
        for (StackListEntry<ItemStack> toExtract : toExtractInitial.getStacks()) {
            ItemStack result = network.extractItem(toExtract.getStack(), toExtract.getStack().func_190916_E(), Action.PERFORM);
            if (result.func_190926_b()) continue;
            internalStorage.insert(toExtract.getStack(), result.func_190916_E(), Action.PERFORM);
            toRemove.add(result);
        }
        for (ItemStack stack : toRemove) {
            toExtractInitial.remove(stack);
        }
        if (!toRemove.isEmpty()) {
            network.getCraftingManager().onTaskChanged();
        }
    }

    public static void extractFluidsFromNetwork(IStackList<FluidStack> toExtractInitial, INetwork network, IStorageDisk<FluidStack> internalStorage) {
        if (toExtractInitial.isEmpty()) {
            return;
        }
        ArrayList<FluidStack> toRemove = new ArrayList<FluidStack>();
        for (StackListEntry<FluidStack> toExtract : toExtractInitial.getStacks()) {
            FluidStack result = network.extractFluid(toExtract.getStack(), toExtract.getStack().getAmount(), Action.PERFORM);
            if (result.isEmpty()) continue;
            internalStorage.insert(result, result.getAmount(), Action.PERFORM);
            toRemove.add(result);
        }
        for (FluidStack stack : toRemove) {
            toExtractInitial.remove(stack);
        }
        if (!toRemove.isEmpty()) {
            network.getCraftingManager().onTaskChanged();
        }
    }
}

