/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.autocrafting;

import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.AllowedTagList;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.CraftingPatternContext;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.CraftingPatternInputs;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.CraftingPatternOutputs;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.CraftingTaskFactory;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;

public class CraftingPattern
implements ICraftingPattern {
    private final CraftingPatternContext context;
    private final boolean processing;
    private final boolean exact;
    @Nullable
    private final ICraftingRecipe recipe;
    private final CraftingPatternInputs inputs;
    private final CraftingPatternOutputs outputs;
    @Nullable
    private final AllowedTagList allowedTagList;

    public CraftingPattern(CraftingPatternContext context, boolean processing, boolean exact, @Nullable ICraftingRecipe recipe, CraftingPatternInputs inputs, CraftingPatternOutputs outputs, @Nullable AllowedTagList allowedTagList) {
        this.context = context;
        this.processing = processing;
        this.exact = exact;
        this.recipe = recipe;
        this.inputs = inputs;
        this.outputs = outputs;
        this.allowedTagList = allowedTagList;
    }

    @Nullable
    public AllowedTagList getAllowedTagList() {
        return this.allowedTagList;
    }

    @Override
    public ICraftingPatternContainer getContainer() {
        return this.context.getContainer();
    }

    @Override
    public ItemStack getStack() {
        return this.context.getStack();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    @Nullable
    public ITextComponent getErrorMessage() {
        return null;
    }

    @Override
    public boolean isProcessing() {
        return this.processing;
    }

    @Override
    public List<NonNullList<ItemStack>> getInputs() {
        return this.inputs.getInputs();
    }

    @Override
    public NonNullList<ItemStack> getOutputs() {
        return this.outputs.getOutputs();
    }

    @Override
    public ItemStack getOutput(NonNullList<ItemStack> took) {
        if (this.processing) {
            throw new IllegalStateException("Cannot get crafting output from processing pattern");
        }
        if (took.size() != this.inputs.getInputs().size()) {
            throw new IllegalArgumentException("The items that are taken (" + took.size() + ") should match the inputs for this pattern (" + this.inputs.getInputs().size() + ")");
        }
        DummyCraftingInventory inv = new DummyCraftingInventory();
        for (int i = 0; i < took.size(); ++i) {
            inv.func_70299_a(i, (ItemStack)took.get(i));
        }
        ItemStack result = this.recipe.func_77572_b((IInventory)inv);
        if (result.func_190926_b()) {
            throw new IllegalStateException("Cannot have empty result");
        }
        return result;
    }

    @Override
    public NonNullList<ItemStack> getByproducts() {
        if (this.processing) {
            throw new IllegalStateException("Cannot get byproduct outputs from processing pattern");
        }
        return this.outputs.getByproducts();
    }

    @Override
    public NonNullList<ItemStack> getByproducts(NonNullList<ItemStack> took) {
        if (this.processing) {
            throw new IllegalStateException("Cannot get byproduct outputs from processing pattern");
        }
        if (took.size() != this.inputs.getInputs().size()) {
            throw new IllegalArgumentException("The items that are taken (" + took.size() + ") should match the inputs for this pattern (" + this.inputs.getInputs().size() + ")");
        }
        DummyCraftingInventory inv = new DummyCraftingInventory();
        for (int i = 0; i < took.size(); ++i) {
            inv.func_70299_a(i, (ItemStack)took.get(i));
        }
        NonNullList remainingItems = this.recipe.func_179532_b((IInventory)inv);
        NonNullList sanitized = NonNullList.func_191196_a();
        for (ItemStack item : remainingItems) {
            if (item.func_190926_b()) continue;
            sanitized.add((Object)item);
        }
        return sanitized;
    }

    @Override
    public List<NonNullList<FluidStack>> getFluidInputs() {
        return this.inputs.getFluidInputs();
    }

    @Override
    public NonNullList<FluidStack> getFluidOutputs() {
        return this.outputs.getFluidOutputs();
    }

    @Override
    public ResourceLocation getCraftingTaskFactoryId() {
        return CraftingTaskFactory.ID;
    }

    public boolean equals(Object otherObj) {
        int j;
        List otherInputsForSlot;
        List inputsForSlot;
        int i;
        if (!(otherObj instanceof ICraftingPattern)) {
            return false;
        }
        ICraftingPattern other = (ICraftingPattern)otherObj;
        if (other.isProcessing() != this.processing) {
            return false;
        }
        if (other.getInputs().size() != this.inputs.getInputs().size() || other.getFluidInputs().size() != this.inputs.getFluidInputs().size() || other.getOutputs().size() != this.outputs.getOutputs().size() || other.getFluidOutputs().size() != this.outputs.getFluidOutputs().size()) {
            return false;
        }
        if (!this.processing && other.getByproducts().size() != this.outputs.getByproducts().size()) {
            return false;
        }
        for (i = 0; i < this.inputs.getInputs().size(); ++i) {
            inputsForSlot = (List)this.inputs.getInputs().get(i);
            otherInputsForSlot = (List)other.getInputs().get(i);
            if (inputsForSlot.size() != otherInputsForSlot.size()) {
                return false;
            }
            for (j = 0; j < inputsForSlot.size(); ++j) {
                if (API.instance().getComparer().isEqual((ItemStack)inputsForSlot.get(j), (ItemStack)otherInputsForSlot.get(j))) continue;
                return false;
            }
        }
        for (i = 0; i < this.inputs.getFluidInputs().size(); ++i) {
            inputsForSlot = (List)this.inputs.getFluidInputs().get(i);
            otherInputsForSlot = (List)other.getFluidInputs().get(i);
            if (inputsForSlot.size() != otherInputsForSlot.size()) {
                return false;
            }
            for (j = 0; j < inputsForSlot.size(); ++j) {
                if (API.instance().getComparer().isEqual((FluidStack)inputsForSlot.get(j), (FluidStack)otherInputsForSlot.get(j), 3)) continue;
                return false;
            }
        }
        for (i = 0; i < this.outputs.getOutputs().size(); ++i) {
            if (API.instance().getComparer().isEqual((ItemStack)this.outputs.getOutputs().get(i), (ItemStack)other.getOutputs().get(i))) continue;
            return false;
        }
        for (i = 0; i < this.outputs.getFluidOutputs().size(); ++i) {
            if (API.instance().getComparer().isEqual((FluidStack)this.outputs.getFluidOutputs().get(i), (FluidStack)other.getFluidOutputs().get(i), 3)) continue;
            return false;
        }
        if (!this.processing) {
            for (i = 0; i < this.outputs.getByproducts().size(); ++i) {
                if (API.instance().getComparer().isEqual((ItemStack)this.outputs.getByproducts().get(i), (ItemStack)other.getByproducts().get(i))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.processing ? 1 : 0);
        result = 31 * result + (this.exact ? 1 : 0);
        for (List list : this.inputs.getInputs()) {
            for (ItemStack input : list) {
                result = 31 * result + API.instance().getItemStackHashCode(input);
            }
        }
        for (List list : this.inputs.getFluidInputs()) {
            for (ItemStack input : list) {
                result = 31 * result + API.instance().getFluidStackHashCode((FluidStack)input);
            }
        }
        for (ItemStack itemStack : this.outputs.getOutputs()) {
            result = 31 * result + API.instance().getItemStackHashCode(itemStack);
        }
        for (FluidStack fluidStack : this.outputs.getFluidOutputs()) {
            result = 31 * result + API.instance().getFluidStackHashCode(fluidStack);
        }
        for (ItemStack itemStack : this.outputs.getByproducts()) {
            result = 31 * result + API.instance().getItemStackHashCode(itemStack);
        }
        return result;
    }

    public static class DummyCraftingInventory
    extends CraftingInventory {
        public DummyCraftingInventory() {
            super(new Container(null, 0){

                public boolean func_75145_c(PlayerEntity player) {
                    return true;
                }
            }, 3, 3);
        }
    }
}

