/*
 * Decompiled with CFR 0.152.
 */
package com.yunus1903.chatembeds.client.embed;

import com.yunus1903.chatembeds.ChatEmbeds;
import com.yunus1903.chatembeds.client.embed.Embed;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.NewChatGui;
import net.minecraft.client.gui.RenderComponentsUtil;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class TextEmbed
extends Embed {
    @Nullable
    private ITextProperties title;
    @Nullable
    private ITextProperties description;

    TextEmbed(URL url, int ticks, int chatLineId) {
        super(url, ticks, chatLineId);
    }

    @Override
    List<? extends ChatLine<IReorderingProcessor>> createChatLines() {
        ArrayList<ChatLine> lines = new ArrayList<ChatLine>();
        if (!this.loadText() || this.title == null) {
            return lines;
        }
        lines.add(new ChatLine(this.ticks, (Object)LanguageMap.func_74808_a().func_241870_a((ITextProperties)new StringTextComponent("")), this.chatLineId));
        lines.add(new ChatLine(this.ticks, (Object)LanguageMap.func_74808_a().func_241870_a(this.title), this.chatLineId));
        lines.add(new ChatLine(this.ticks, (Object)LanguageMap.func_74808_a().func_241870_a((ITextProperties)new StringTextComponent("")), this.chatLineId));
        if (this.description != null) {
            int i = MathHelper.func_76128_c((double)((double)NewChatGui.func_194814_b((double)Minecraft.func_71410_x().field_71474_y.field_96692_F) / Minecraft.func_71410_x().field_71474_y.field_96691_E));
            this.description = ((IFormattableTextComponent)this.description).func_240699_a_(TextFormatting.GRAY);
            List list = RenderComponentsUtil.func_238505_a_((ITextProperties)this.description, (int)i, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
            list.forEach(line -> lines.add(new ChatLine(this.ticks, line, this.chatLineId)));
            lines.add(new ChatLine(this.ticks, (Object)LanguageMap.func_74808_a().func_241870_a((ITextProperties)new StringTextComponent("")), this.chatLineId));
        }
        return lines;
    }

    private boolean loadText() {
        HTMLDocument doc = (HTMLDocument)new HTMLEditorKit().createDefaultDocument();
        ParserDelegator parser = new ParserDelegator();
        try {
            if (this.connection == null) {
                return false;
            }
            ((HTMLEditorKit.Parser)parser).parse(new InputStreamReader(this.connection.getInputStream()), doc.getReader(0), true);
        }
        catch (IOException e) {
            ChatEmbeds.LOGGER.error("Exception reading HTML", (Throwable)e);
        }
        try {
            this.title = new StringTextComponent(doc.getProperty("title").toString()).func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.UNDERLINE});
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (this.title == null) {
            try {
                this.title = new StringTextComponent((String)doc.getElement(doc.getDefaultRootElement(), HTML.Attribute.NAME, "title").getAttributes().getAttribute(HTML.Attribute.CONTENT)).func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.UNDERLINE});
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        try {
            String desc = (String)doc.getElement(doc.getDefaultRootElement(), HTML.Attribute.NAME, "description").getAttributes().getAttribute(HTML.Attribute.CONTENT);
            this.description = new StringTextComponent(desc.replace("\r", "\n"));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return true;
    }

    @Nullable
    public ITextProperties getTitle() {
        return this.title;
    }

    @Nullable
    public ITextProperties getDescription() {
        return this.description;
    }
}

