/*
 * Decompiled with CFR 0.152.
 */
package com.yunus1903.chatembeds.client.embed;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.yunus1903.chatembeds.ChatEmbeds;
import com.yunus1903.chatembeds.ChatEmbedsConfig;
import com.yunus1903.chatembeds.client.EmbedChatLine;
import com.yunus1903.chatembeds.client.embed.Embed;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.client.gui.NewChatGui;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;

public class ImageEmbed
extends Embed {
    private NativeImage image;
    private NativeImage scaledImage;
    private ResourceLocation imageResourceLocation;

    ImageEmbed(URL url, int ticks, int chatLineId) {
        super(url, ticks, chatLineId);
    }

    @Override
    List<? extends ChatLine<IReorderingProcessor>> createChatLines() {
        ArrayList<ChatLine> lines = new ArrayList<ChatLine>();
        if (!this.loadImage()) {
            return lines;
        }
        if (!ChatEmbedsConfig.GeneralConfig.removeUrlMessage) {
            lines.add(new ChatLine(this.ticks, (Object)LanguageMap.func_74808_a().func_241870_a((ITextProperties)new StringTextComponent("")), this.chatLineId));
        }
        double imageHeight = this.scaledImage.func_195714_b();
        double lineHeight = 9.0;
        double totalLines = imageHeight / lineHeight;
        int i = 0;
        while ((double)i < Math.ceil(totalLines)) {
            double heightScale = i == (int)totalLines ? totalLines - (double)i : 1.0;
            final float u0 = 0.0f;
            final float v0 = (float)((double)i * lineHeight);
            final int destWidth = this.scaledImage.func_195702_a();
            final int destHeight = (int)(lineHeight * heightScale);
            final int textureWidth = this.scaledImage.func_195702_a();
            final int textureHeight = this.scaledImage.func_195714_b();
            lines.add(new EmbedChatLine<ImageEmbed>(this.ticks, this.chatLineId, this){

                @Override
                public void render(Minecraft mc, MatrixStack matrixStack, int x, int y) {
                    mc.func_110434_K().func_110577_a(ImageEmbed.this.imageResourceLocation);
                    AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)x, (int)y, (float)u0, (float)v0, (int)destWidth, (int)destHeight, (int)textureWidth, (int)textureHeight);
                }

                @Override
                public int getWidth() {
                    return ImageEmbed.this.scaledImage.func_195702_a();
                }
            });
            ++i;
        }
        return lines;
    }

    private boolean loadImage() {
        try {
            if (this.connection == null) {
                return false;
            }
            this.image = NativeImage.func_195713_a((InputStream)this.connection.getInputStream());
        }
        catch (IOException e) {
            ChatEmbeds.LOGGER.error("Exception reading image", (Throwable)e);
        }
        if (this.image == null) {
            return false;
        }
        NewChatGui gui = Minecraft.func_71410_x().field_71456_v.field_73840_e;
        this.scaledImage = ImageEmbed.scaleImage(this.image, Math.min(ChatEmbedsConfig.GeneralConfig.chatImageEmbedMaxWidth, gui.func_146228_f()), ChatEmbedsConfig.GeneralConfig.chatImageEmbedMaxHeight);
        this.imageResourceLocation = Minecraft.func_71410_x().func_110434_K().func_110578_a("chat_embed_image", new DynamicTexture(this.image));
        return true;
    }

    protected static NativeImage scaleImage(NativeImage image, int maxWidth, int maxHeight) {
        int width = image.func_195702_a();
        int height = image.func_195714_b();
        if (width > maxWidth) {
            width = maxWidth;
            height = (int)((float)image.func_195714_b() / (float)image.func_195702_a() * (float)width);
        }
        if (height > maxHeight) {
            height = maxHeight;
            width = (int)((float)image.func_195702_a() / (float)image.func_195714_b() * (float)height);
        }
        NativeImage scaledImage = new NativeImage(width, height, false);
        image.func_195708_a(0, 0, image.func_195702_a(), image.func_195714_b(), scaledImage);
        return scaledImage;
    }

    public NativeImage getImage() {
        return this.image;
    }

    public NativeImage getScaledImage() {
        return this.scaledImage;
    }

    public ResourceLocation getImageResourceLocation() {
        return this.imageResourceLocation;
    }
}

