/*
 * Decompiled with CFR 0.152.
 */
package com.yunus1903.chatembeds.client.embed;

import com.yunus1903.chatembeds.ChatEmbeds;
import com.yunus1903.chatembeds.ChatEmbedsConfig;
import com.yunus1903.chatembeds.client.embed.AnimatedImageEmbed;
import com.yunus1903.chatembeds.client.embed.ImageEmbed;
import com.yunus1903.chatembeds.client.embed.ImageExtractor;
import com.yunus1903.chatembeds.client.embed.TextEmbed;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.util.IReorderingProcessor;

public abstract class Embed {
    private static final String USER_AGENT = "Mozilla/4.0";
    final URL url;
    final int ticks;
    final int chatLineId;
    @Nullable
    final HttpURLConnection connection;
    private final List<? extends ChatLine<IReorderingProcessor>> chatLines;

    Embed(URL url, int ticks, int chatLineId) {
        this.url = url;
        this.ticks = ticks;
        this.chatLineId = chatLineId;
        this.connection = this.openConnection();
        this.chatLines = this.createChatLines();
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    @Nullable
    private HttpURLConnection openConnection() {
        try {
            HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
            connection.addRequestProperty("User-Agent", USER_AGENT);
            return connection;
        }
        catch (IOException e) {
            ChatEmbeds.LOGGER.error("Failed to open connection", (Throwable)e);
            return null;
        }
    }

    abstract List<? extends ChatLine<IReorderingProcessor>> createChatLines();

    public List<? extends ChatLine<IReorderingProcessor>> getChatLines() {
        return this.chatLines;
    }

    public URL getUrl() {
        return this.url;
    }

    public static class Builder {
        private final String url;
        private final int ticks;
        private final int chatLineId;

        public Builder(String url, int ticks, int chatLineId) {
            this.url = url;
            this.ticks = ticks;
            this.chatLineId = chatLineId;
        }

        @Nullable
        public Embed build() {
            URL parsedURL = Builder.parseURL(this.url);
            if (parsedURL == null) {
                return null;
            }
            String extension = parsedURL.toString().substring(parsedURL.toString().lastIndexOf(".") + 1);
            if (extension.contains("?")) {
                extension = extension.substring(0, extension.indexOf("?"));
            }
            try {
                String imageURL = ImageExtractor.extractImageURL(parsedURL);
                if (imageURL != null) {
                    parsedURL = new URL(imageURL);
                    if (extension.equals("gif") || extension.equals("gifv")) {
                        if (ChatEmbedsConfig.GeneralConfig.enableAnimatedImageEmbeds) {
                            return new AnimatedImageEmbed(parsedURL, this.ticks, this.chatLineId);
                        }
                    } else if (ChatEmbedsConfig.GeneralConfig.enableImageEmbeds) {
                        return new ImageEmbed(parsedURL, this.ticks, this.chatLineId);
                    }
                }
            }
            catch (MalformedURLException e) {
                ChatEmbeds.LOGGER.debug("Failed to recreate URL", (Throwable)e);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (ChatEmbedsConfig.GeneralConfig.enableTextEmbeds) {
                return new TextEmbed(parsedURL, this.ticks, this.chatLineId);
            }
            return null;
        }

        @Nullable
        private static URL parseURL(String url) {
            URL parsedURL = null;
            try {
                if (new URI(url).getScheme() == null) {
                    url = "http://" + url;
                }
                parsedURL = new URL(url);
            }
            catch (MalformedURLException | URISyntaxException e) {
                ChatEmbeds.LOGGER.error("Failed to parse URL", (Throwable)e);
            }
            return parsedURL;
        }
    }
}

