/*
 * Decompiled with CFR 0.152.
 */
package com.yunus1903.chatembeds.client.embed;

import at.dhyan.open_imaging.GifDecoder;
import com.google.common.io.ByteStreams;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.yunus1903.chatembeds.ChatEmbeds;
import com.yunus1903.chatembeds.ChatEmbedsConfig;
import com.yunus1903.chatembeds.client.EmbedChatLine;
import com.yunus1903.chatembeds.client.embed.Embed;
import com.yunus1903.chatembeds.client.embed.ImageEmbed;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.client.gui.NewChatGui;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;

public class AnimatedImageEmbed
extends Embed {
    private List<Frame> frames;
    protected EmbedChatLine<AnimatedImageEmbed> currentRenderer;
    protected int currentFrame;

    AnimatedImageEmbed(URL url, int ticks, int chatLineId) {
        super(url, ticks, chatLineId);
    }

    @Override
    List<? extends ChatLine<IReorderingProcessor>> createChatLines() {
        this.frames = new ArrayList<Frame>();
        ArrayList<ChatLine> lines = new ArrayList<ChatLine>();
        if (!this.loadImage()) {
            return lines;
        }
        if (!ChatEmbedsConfig.GeneralConfig.removeUrlMessage) {
            lines.add(new ChatLine(this.ticks, (Object)LanguageMap.func_74808_a().func_241870_a((ITextProperties)new StringTextComponent("")), this.chatLineId));
        }
        final NativeImage scaledImage = this.frames.get(0).getScaledImage();
        double imageHeight = scaledImage.func_195714_b();
        double lineHeight = 9.0;
        double totalLines = imageHeight / lineHeight;
        int i = 0;
        while ((double)i < Math.ceil(totalLines)) {
            double heightScale = i == (int)totalLines ? totalLines - (double)i : 1.0;
            final float u0 = 0.0f;
            final float v0 = (float)((double)i * lineHeight);
            final int destWidth = scaledImage.func_195702_a();
            final int destHeight = (int)(lineHeight * heightScale);
            final int textureWidth = scaledImage.func_195702_a();
            final int textureHeight = scaledImage.func_195714_b();
            lines.add(new EmbedChatLine<AnimatedImageEmbed>(this.ticks, this.chatLineId, this){
                private int time;
                private int lastFrameIndex;
                private int lastScrollPos;

                @Override
                public void render(Minecraft mc, MatrixStack matrixStack, int x, int y) {
                    if (this.lastScrollPos != mc.field_71456_v.func_146158_b().field_146250_j) {
                        AnimatedImageEmbed.this.currentRenderer = null;
                        this.lastScrollPos = mc.field_71456_v.func_146158_b().field_146250_j;
                    }
                    if (AnimatedImageEmbed.this.currentRenderer == null) {
                        AnimatedImageEmbed.this.currentRenderer = this;
                    }
                    if (AnimatedImageEmbed.this.currentRenderer == this) {
                        int frameIndex = mc.field_181542_y.func_181750_b();
                        if (this.lastFrameIndex != frameIndex) {
                            this.lastFrameIndex = frameIndex;
                            ++this.time;
                        }
                        if (this.time >= ((Frame)AnimatedImageEmbed.this.frames.get(AnimatedImageEmbed.this.currentFrame)).getDelay() / 2) {
                            this.time = 0;
                            AnimatedImageEmbed.this.currentFrame = AnimatedImageEmbed.this.currentFrame + 1 >= AnimatedImageEmbed.this.frames.size() ? 0 : ++AnimatedImageEmbed.this.currentFrame;
                        }
                    }
                    mc.func_110434_K().func_110577_a(((Frame)AnimatedImageEmbed.this.frames.get(AnimatedImageEmbed.this.currentFrame)).getResourceLocation());
                    AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)x, (int)y, (float)u0, (float)v0, (int)destWidth, (int)destHeight, (int)textureWidth, (int)textureHeight);
                }

                @Override
                public int getWidth() {
                    return scaledImage.func_195702_a();
                }
            });
            ++i;
        }
        return lines;
    }

    private boolean loadImage() {
        GifDecoder.GifImage image = null;
        try {
            if (this.connection == null) {
                return false;
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(){

                @Override
                public synchronized byte[] toByteArray() {
                    return this.buf;
                }
            };
            ByteStreams.copy((InputStream)this.connection.getInputStream(), (OutputStream)outputStream);
            image = GifDecoder.read(new ByteArrayInputStream(outputStream.toByteArray(), 0, outputStream.size()));
        }
        catch (IOException e) {
            ChatEmbeds.LOGGER.error("Exception getting image from InputStream", (Throwable)e);
        }
        if (image == null) {
            return false;
        }
        try {
            int numberOfFrames = image.getFrameCount();
            if (numberOfFrames == 0) {
                return false;
            }
            for (int i = 0; i < image.getFrameCount(); ++i) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)image.getFrame(i), "gif", outputStream);
                NativeImage nativeImage = NativeImage.func_195713_a((InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
                ResourceLocation resourceLocation = Minecraft.func_71410_x().func_110434_K().func_110578_a("chat_embed_animated_image_frame_" + i, new DynamicTexture(nativeImage));
                this.frames.add(new Frame(nativeImage, resourceLocation, image.getDelay(i)));
            }
        }
        catch (IOException e) {
            ChatEmbeds.LOGGER.error("Exception loading animated image", (Throwable)e);
        }
        return !this.frames.isEmpty();
    }

    public List<Frame> getFrames() {
        return Collections.unmodifiableList(this.frames);
    }

    public static class Frame {
        private final NativeImage image;
        private final NativeImage scaledImage;
        private final ResourceLocation resourceLocation;
        private final int delay;

        private Frame(NativeImage image, ResourceLocation resourceLocation, int delay) {
            this.image = image;
            NewChatGui gui = Minecraft.func_71410_x().field_71456_v.field_73840_e;
            this.scaledImage = ImageEmbed.scaleImage(image, Math.min(ChatEmbedsConfig.GeneralConfig.chatImageEmbedMaxWidth, gui.func_146228_f()), ChatEmbedsConfig.GeneralConfig.chatImageEmbedMaxHeight);
            this.resourceLocation = resourceLocation;
            this.delay = delay;
        }

        public NativeImage getImage() {
            return this.image;
        }

        public NativeImage getScaledImage() {
            return this.scaledImage;
        }

        public ResourceLocation getResourceLocation() {
            return this.resourceLocation;
        }

        public int getDelay() {
            return this.delay;
        }
    }
}

