/*
 * Decompiled with CFR 0.152.
 */
package com.yunus1903.chatembeds;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber(modid="chatembeds", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ChatEmbedsConfig {
    public static final GeneralConfig GENERAL;
    public static final ForgeConfigSpec CLIENT_SPEC;

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent event) {
        if (event.getConfig().getSpec() == CLIENT_SPEC) {
            GENERAL.bake();
        }
    }

    static {
        ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
        GENERAL = new GeneralConfig(BUILDER);
        CLIENT_SPEC = BUILDER.build();
    }

    public static class GeneralConfig {
        public static boolean enableImageEmbeds;
        public static boolean enableAnimatedImageEmbeds;
        public static boolean enableTextEmbeds;
        public static int chatImageEmbedMaxWidth;
        public static int chatImageEmbedMaxHeight;
        public static boolean removeUrlMessage;
        private final ForgeConfigSpec.BooleanValue ENABLE_IMAGE_EMBEDS;
        private final ForgeConfigSpec.BooleanValue ENABLE_ANIMATED_IMAGE_EMBEDS;
        private final ForgeConfigSpec.BooleanValue ENABLE_TEXT_EMBEDS;
        private final ForgeConfigSpec.IntValue CHAT_IMAGE_EMBED_MAX_WIDTH;
        private final ForgeConfigSpec.IntValue CHAT_IMAGE_EMBED_MAX_HEIGHT;
        private final ForgeConfigSpec.BooleanValue REMOVE_URL_MESSAGE;

        public GeneralConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("General config").push("general");
            this.ENABLE_IMAGE_EMBEDS = builder.comment("Enable image embeds (png, jpg, jpeg)").define("enableImageEmbeds", true);
            this.ENABLE_ANIMATED_IMAGE_EMBEDS = builder.comment("Enable animated image embeds (gif)").define("enableAnimatedImageEmbeds", true);
            this.ENABLE_TEXT_EMBEDS = builder.comment("Enable text embeds (Work in progress)").define("enableTextEmbeds", false);
            this.CHAT_IMAGE_EMBED_MAX_WIDTH = builder.comment("Max width of image embeds").defineInRange("chatImageEmbedMaxWidth", 300, 0, 320);
            this.CHAT_IMAGE_EMBED_MAX_HEIGHT = builder.comment("Max height of image embeds").defineInRange("chatImageEmbedMaxHeight", 100, 0, 320);
            this.REMOVE_URL_MESSAGE = builder.comment("Remove the message containing the original url when embedding.").define("removeUrlMessage", true);
            builder.pop();
        }

        public void bake() {
            enableImageEmbeds = (Boolean)this.ENABLE_IMAGE_EMBEDS.get();
            enableAnimatedImageEmbeds = (Boolean)this.ENABLE_ANIMATED_IMAGE_EMBEDS.get();
            enableTextEmbeds = (Boolean)this.ENABLE_TEXT_EMBEDS.get();
            chatImageEmbedMaxWidth = (Integer)this.CHAT_IMAGE_EMBED_MAX_WIDTH.get();
            chatImageEmbedMaxHeight = (Integer)this.CHAT_IMAGE_EMBED_MAX_HEIGHT.get();
            removeUrlMessage = (Boolean)this.REMOVE_URL_MESSAGE.get();
        }
    }
}

