/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.registry.forge;

import com.google.common.base.Objects;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.shedaniel.architectury.core.RegistryEntry;
import me.shedaniel.architectury.platform.forge.EventBuses;
import me.shedaniel.architectury.registry.Registries;
import me.shedaniel.architectury.registry.Registry;
import me.shedaniel.architectury.registry.RegistrySupplier;
import me.shedaniel.architectury.registry.registries.RegistryBuilder;
import me.shedaniel.architectury.registry.registries.RegistryOption;
import me.shedaniel.architectury.registry.registries.StandardRegistryOption;
import net.minecraft.util.LazyValue;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;
import org.jetbrains.annotations.NotNull;

public class RegistriesImpl {
    public static Registries.RegistryProvider _get(String modId) {
        return new RegistryProviderImpl(modId);
    }

    public static <T> ResourceLocation getId(T t, RegistryKey<net.minecraft.util.registry.Registry<T>> registryKey) {
        if (t instanceof IForgeRegistryEntry) {
            return ((IForgeRegistryEntry)t).getRegistryName();
        }
        return null;
    }

    public static <T> ResourceLocation getId(T t, net.minecraft.util.registry.Registry<T> registry) {
        if (t instanceof IForgeRegistryEntry) {
            return ((IForgeRegistryEntry)t).getRegistryName();
        }
        return null;
    }

    public static class ForgeBackedRegistryImpl<T extends IForgeRegistryEntry<T>>
    implements Registry<T> {
        private IForgeRegistry<T> delegate;
        private Table<Type, RegistryObject<?>, Supplier<? extends IForgeRegistryEntry<?>>> registry;

        public ForgeBackedRegistryImpl(Table<Type, RegistryObject<?>, Supplier<? extends IForgeRegistryEntry<?>>> registry, IForgeRegistry<T> delegate) {
            this.registry = registry;
            this.delegate = delegate;
        }

        @Override
        @NotNull
        public RegistrySupplier<T> delegateSupplied(final ResourceLocation id) {
            final LazyValue value = new LazyValue(() -> this.get(id));
            return new RegistrySupplier<T>(){

                @Override
                @NotNull
                public ResourceLocation getRegistryId() {
                    return delegate.getRegistryName();
                }

                @Override
                @NotNull
                public ResourceLocation getId() {
                    return id;
                }

                @Override
                public boolean isPresent() {
                    return this.contains(id);
                }

                @Override
                public T get() {
                    return (IForgeRegistryEntry)value.func_179281_c();
                }

                public int hashCode() {
                    return Objects.hashCode((Object[])new Object[]{this.getRegistryId(), this.getId()});
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (!(obj instanceof RegistrySupplier)) {
                        return false;
                    }
                    RegistrySupplier other = (RegistrySupplier)obj;
                    return other.getRegistryId().equals((Object)this.getRegistryId()) && other.getId().equals((Object)this.getId());
                }

                public String toString() {
                    return this.getRegistryId().toString() + "@" + id.toString();
                }
            };
        }

        @Override
        @NotNull
        public RegistrySupplier<T> registerSupplied(final ResourceLocation id, Supplier<T> supplier) {
            final RegistryObject registryObject = RegistryObject.of((ResourceLocation)id, this.delegate);
            this.registry.put((Object)this.delegate.getRegistrySuperType(), (Object)registryObject, () -> (IForgeRegistryEntry)((IForgeRegistryEntry)supplier.get()).setRegistryName(id));
            return new RegistrySupplier<T>(){

                @Override
                @NotNull
                public ResourceLocation getRegistryId() {
                    return delegate.getRegistryName();
                }

                @Override
                @NotNull
                public ResourceLocation getId() {
                    return registryObject.getId();
                }

                @Override
                public boolean isPresent() {
                    return registryObject.isPresent();
                }

                @Override
                public T get() {
                    return registryObject.get();
                }

                public int hashCode() {
                    return Objects.hashCode((Object[])new Object[]{this.getRegistryId(), this.getId()});
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (!(obj instanceof RegistrySupplier)) {
                        return false;
                    }
                    RegistrySupplier other = (RegistrySupplier)obj;
                    return other.getRegistryId().equals((Object)this.getRegistryId()) && other.getId().equals((Object)this.getId());
                }

                public String toString() {
                    return this.getRegistryId().toString() + "@" + id.toString();
                }
            };
        }

        @Override
        @Nullable
        public ResourceLocation getId(T obj) {
            return this.delegate.getKey(obj);
        }

        @Override
        public int getRawId(T obj) {
            return ((ForgeRegistry)this.delegate).getID(obj);
        }

        @Override
        public Optional<RegistryKey<T>> getKey(T t) {
            return Optional.ofNullable(this.getId(t)).map(id -> RegistryKey.func_240903_a_(this.key(), (ResourceLocation)id));
        }

        @Override
        @Nullable
        public T get(ResourceLocation id) {
            return (T)this.delegate.getValue(id);
        }

        @Override
        public T byRawId(int rawId) {
            return (T)((ForgeRegistry)this.delegate).getValue(rawId);
        }

        @Override
        public boolean contains(ResourceLocation resourceLocation) {
            return this.delegate.containsKey(resourceLocation);
        }

        @Override
        public boolean containsValue(T t) {
            return this.delegate.containsValue(t);
        }

        @Override
        public Set<ResourceLocation> getIds() {
            return this.delegate.getKeys();
        }

        @Override
        public Set<Map.Entry<RegistryKey<T>, T>> entrySet() {
            return this.delegate.getEntries();
        }

        @Override
        public RegistryKey<? extends net.minecraft.util.registry.Registry<T>> key() {
            return RegistryKey.func_240904_a_((ResourceLocation)this.delegate.getRegistryName());
        }

        @Override
        public Iterator<T> iterator() {
            return this.delegate.iterator();
        }
    }

    public static class VanillaBackedRegistryImpl<T>
    implements Registry<T> {
        private net.minecraft.util.registry.Registry<T> delegate;

        public VanillaBackedRegistryImpl(net.minecraft.util.registry.Registry<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        @NotNull
        public RegistrySupplier<T> delegateSupplied(final ResourceLocation id) {
            final LazyValue value = new LazyValue(() -> this.get(id));
            return new RegistrySupplier<T>(){

                @Override
                @NotNull
                public ResourceLocation getRegistryId() {
                    return delegate.func_243578_f().func_240901_a_();
                }

                @Override
                @NotNull
                public ResourceLocation getId() {
                    return id;
                }

                @Override
                public boolean isPresent() {
                    return this.contains(id);
                }

                @Override
                public T get() {
                    return value.func_179281_c();
                }

                public int hashCode() {
                    return Objects.hashCode((Object[])new Object[]{this.getRegistryId(), this.getId()});
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (!(obj instanceof RegistrySupplier)) {
                        return false;
                    }
                    RegistrySupplier other = (RegistrySupplier)obj;
                    return other.getRegistryId().equals((Object)this.getRegistryId()) && other.getId().equals((Object)this.getId());
                }

                public String toString() {
                    return this.getRegistryId().toString() + "@" + id.toString();
                }
            };
        }

        @Override
        @NotNull
        public RegistrySupplier<T> registerSupplied(ResourceLocation id, Supplier<T> supplier) {
            net.minecraft.util.registry.Registry.func_218322_a(this.delegate, (ResourceLocation)id, supplier.get());
            return this.delegateSupplied(id);
        }

        @Override
        @Nullable
        public ResourceLocation getId(T obj) {
            return this.delegate.func_177774_c(obj);
        }

        @Override
        public int getRawId(T obj) {
            return this.delegate.func_148757_b(obj);
        }

        @Override
        public Optional<RegistryKey<T>> getKey(T t) {
            return this.delegate.func_230519_c_(t);
        }

        @Override
        @Nullable
        public T get(ResourceLocation id) {
            return (T)this.delegate.func_82594_a(id);
        }

        @Override
        public T byRawId(int rawId) {
            return (T)this.delegate.func_148745_a(rawId);
        }

        @Override
        public boolean contains(ResourceLocation resourceLocation) {
            return this.delegate.func_148742_b().contains(resourceLocation);
        }

        @Override
        public boolean containsValue(T t) {
            return this.delegate.func_230519_c_(t).isPresent();
        }

        @Override
        public Set<ResourceLocation> getIds() {
            return this.delegate.func_148742_b();
        }

        @Override
        public Set<Map.Entry<RegistryKey<T>, T>> entrySet() {
            return this.delegate.func_239659_c_();
        }

        @Override
        public RegistryKey<? extends net.minecraft.util.registry.Registry<T>> key() {
            return this.delegate.func_243578_f();
        }

        @Override
        public Iterator<T> iterator() {
            return this.delegate.iterator();
        }
    }

    public static class RegistryBuilderWrapper<T extends RegistryEntry<T>>
    implements RegistryBuilder<T> {
        @NotNull
        private final RegistryProviderImpl provider;
        @NotNull
        private final net.minecraftforge.registries.RegistryBuilder<?> builder;
        private boolean saveToDisk = false;
        private boolean syncToClients = false;

        public RegistryBuilderWrapper(@NotNull RegistryProviderImpl provider, @NotNull net.minecraftforge.registries.RegistryBuilder<?> builder) {
            this.provider = provider;
            this.builder = builder;
        }

        @Override
        @NotNull
        public Registry<T> build() {
            if (!this.syncToClients) {
                this.builder.disableSync();
            }
            if (!this.saveToDisk) {
                this.builder.disableSaving();
            }
            return this.provider.get(this.builder.create());
        }

        @Override
        @NotNull
        public RegistryBuilder<T> option(@NotNull RegistryOption option) {
            if (option == StandardRegistryOption.SAVE_TO_DISC) {
                this.saveToDisk = true;
            } else if (option == StandardRegistryOption.SYNC_TO_CLIENTS) {
                this.syncToClients = true;
            }
            return this;
        }
    }

    public static class RegistryProviderImpl
    implements Registries.RegistryProvider {
        private final String modId;
        private final IEventBus eventBus;
        private final Table<Type, RegistryObject<?>, Supplier<? extends IForgeRegistryEntry<?>>> registry = HashBasedTable.create();

        public RegistryProviderImpl(String modId) {
            this.modId = modId;
            this.eventBus = EventBuses.getModEventBus(modId).orElseThrow(() -> new IllegalStateException("Can't get event bus for mod '" + modId + "' because it was not registered!"));
            this.eventBus.register((Object)new EventListener());
        }

        @Override
        public <T> Registry<T> get(RegistryKey<net.minecraft.util.registry.Registry<T>> registryKey) {
            return this.get((IForgeRegistry)RegistryManager.ACTIVE.getRegistry(registryKey.func_240901_a_()));
        }

        public <T> Registry<T> get(IForgeRegistry registry) {
            return new ForgeBackedRegistryImpl(this.registry, registry);
        }

        @Override
        public <T> Registry<T> get(net.minecraft.util.registry.Registry<T> registry) {
            return new VanillaBackedRegistryImpl<T>(registry);
        }

        @Override
        public <T extends RegistryEntry<T>> RegistryBuilder<T> builder(Class<T> type, ResourceLocation registryId) {
            return new RegistryBuilderWrapper(this, new net.minecraftforge.registries.RegistryBuilder().setName(registryId).setType(type));
        }

        public class EventListener {
            @SubscribeEvent
            public void handleEvent(RegistryEvent.Register event) {
                IForgeRegistry registry = event.getRegistry();
                for (Map.Entry row : RegistryProviderImpl.this.registry.rowMap().entrySet()) {
                    if (row.getKey() != event.getGenericType()) continue;
                    for (Map.Entry entry : ((Map)row.getValue()).entrySet()) {
                        registry.register((IForgeRegistryEntry)((Supplier)entry.getValue()).get());
                        ((RegistryObject)entry.getKey()).updateReference(registry);
                    }
                }
            }
        }
    }
}

