/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.registry.forge;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.shedaniel.architectury.hooks.biome.BiomeHooks;
import me.shedaniel.architectury.hooks.biome.BiomeProperties;
import me.shedaniel.architectury.hooks.biome.ClimateProperties;
import me.shedaniel.architectury.hooks.biome.EffectsProperties;
import me.shedaniel.architectury.hooks.biome.GenerationProperties;
import me.shedaniel.architectury.hooks.biome.SpawnProperties;
import me.shedaniel.architectury.mixin.forge.BiomeGenerationSettingsBuilderAccessor;
import me.shedaniel.architectury.mixin.forge.MobSpawnSettingsBuilderAccessor;
import me.shedaniel.architectury.registry.BiomeModifications;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="architectury")
public class BiomeModificationsImpl {
    private static final List<Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>> MODIFICATIONS = Lists.newArrayList();

    public static void addProperties(Predicate<BiomeModifications.BiomeContext> predicate, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable> modifier) {
        MODIFICATIONS.add((Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>)Pair.of(predicate, modifier));
    }

    public static void postProcessProperties(Predicate<BiomeModifications.BiomeContext> predicate, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable> modifier) {
        MODIFICATIONS.add((Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>)Pair.of(predicate, modifier));
    }

    public static void removeProperties(Predicate<BiomeModifications.BiomeContext> predicate, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable> modifier) {
        MODIFICATIONS.add((Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>)Pair.of(predicate, modifier));
    }

    public static void replaceProperties(Predicate<BiomeModifications.BiomeContext> predicate, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable> modifier) {
        MODIFICATIONS.add((Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>)Pair.of(predicate, modifier));
    }

    private static BiomeModifications.BiomeContext wrapSelectionContext(final BiomeLoadingEvent event) {
        return new BiomeModifications.BiomeContext(){
            BiomeProperties properties;
            {
                this.properties = new BiomeWrapped(event);
            }

            @Override
            @NotNull
            public ResourceLocation getKey() {
                return event.getName();
            }

            @Override
            @NotNull
            public BiomeProperties getProperties() {
                return this.properties;
            }
        };
    }

    @SubscribeEvent
    public static void onBiomeLoading(BiomeLoadingEvent event) {
        BiomeModifications.BiomeContext biomeContext = BiomeModificationsImpl.wrapSelectionContext(event);
        MutableBiomeWrapped mutableBiome = new MutableBiomeWrapped(event);
        for (Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>> pair : MODIFICATIONS) {
            if (!((Predicate)pair.getLeft()).test(biomeContext)) continue;
            ((BiConsumer)pair.getRight()).accept(biomeContext, mutableBiome);
        }
        MutableClimatePropertiesWrapped climateProperties = (MutableClimatePropertiesWrapped)mutableBiome.getClimateProperties();
        if (climateProperties.dirty) {
            event.setClimate(new Biome.Climate(climateProperties.precipitation, climateProperties.temperature, climateProperties.temperatureModifier, climateProperties.downfall));
        }
    }

    private static class MutableSpawnSettingsBuilderWrapped
    extends SpawnSettingsBuilderWrapped
    implements SpawnProperties.Mutable {
        public MutableSpawnSettingsBuilderWrapped(MobSpawnInfoBuilder builder) {
            super(builder);
        }

        @Override
        @NotNull
        public SpawnProperties.Mutable setCreatureProbability(float probability) {
            this.builder.func_242572_a(probability);
            return this;
        }

        @Override
        public SpawnProperties.Mutable addSpawn(EntityClassification category, MobSpawnInfo.Spawners data) {
            this.builder.func_242575_a(category, data);
            return this;
        }

        @Override
        public boolean removeSpawns(BiPredicate<EntityClassification, MobSpawnInfo.Spawners> predicate) {
            boolean removed = false;
            for (EntityClassification type : this.builder.getSpawnerTypes()) {
                if (!this.builder.getSpawner(type).removeIf(data -> predicate.test(type, (MobSpawnInfo.Spawners)data))) continue;
                removed = true;
            }
            return removed;
        }

        @Override
        public SpawnProperties.Mutable setSpawnCost(EntityType<?> entityType, MobSpawnInfo.SpawnCosts cost) {
            this.builder.func_242573_a(entityType, cost.func_242585_b(), cost.func_242582_a());
            return this;
        }

        @Override
        public SpawnProperties.Mutable setSpawnCost(EntityType<?> entityType, double mass, double gravityLimit) {
            this.builder.func_242573_a(entityType, mass, gravityLimit);
            return this;
        }

        @Override
        public SpawnProperties.Mutable clearSpawnCost(EntityType<?> entityType) {
            this.getMobSpawnCosts().remove(entityType);
            return this;
        }

        @Override
        @NotNull
        public SpawnProperties.Mutable setPlayerSpawnFriendly(boolean friendly) {
            ((MobSpawnSettingsBuilderAccessor)this.builder).setPlayerCanSpawn(friendly);
            return this;
        }
    }

    private static class MutableGenerationSettingsBuilderWrapped
    extends GenerationSettingsBuilderWrapped
    implements GenerationProperties.Mutable {
        public MutableGenerationSettingsBuilderWrapped(BiomeGenerationSettingsBuilder generation) {
            super(generation);
        }

        @Override
        public GenerationProperties.Mutable setSurfaceBuilder(ConfiguredSurfaceBuilder<?> builder) {
            this.generation.func_242517_a(builder);
            return this;
        }

        @Override
        public GenerationProperties.Mutable addFeature(GenerationStage.Decoration decoration, ConfiguredFeature<?, ?> feature) {
            this.generation.func_242513_a(decoration, feature);
            return this;
        }

        @Override
        public GenerationProperties.Mutable addCarver(GenerationStage.Carving carving, ConfiguredCarver<?> feature) {
            this.generation.func_242512_a(carving, feature);
            return this;
        }

        @Override
        public GenerationProperties.Mutable addStructure(StructureFeature<?, ?> feature) {
            this.generation.func_242516_a(feature);
            return this;
        }

        @Override
        public GenerationProperties.Mutable removeFeature(GenerationStage.Decoration decoration, ConfiguredFeature<?, ?> feature) {
            this.generation.getFeatures(decoration).removeIf(supplier -> supplier.get() == feature);
            return this;
        }

        @Override
        public GenerationProperties.Mutable removeCarver(GenerationStage.Carving carving, ConfiguredCarver<?> feature) {
            this.generation.getCarvers(carving).removeIf(supplier -> supplier.get() == feature);
            return this;
        }

        @Override
        public GenerationProperties.Mutable removeStructure(StructureFeature<?, ?> feature) {
            this.generation.getStructures().removeIf(supplier -> supplier.get() == feature);
            return this;
        }
    }

    public static class MutableClimatePropertiesWrapped
    implements ClimateProperties.Mutable {
        public Biome.RainType precipitation;
        public float temperature;
        public Biome.TemperatureModifier temperatureModifier;
        public float downfall;
        public boolean dirty;

        public MutableClimatePropertiesWrapped(Biome.Climate settings) {
            this(settings.field_242460_b, settings.field_242461_c, settings.field_242462_d, settings.field_242463_e);
        }

        public MutableClimatePropertiesWrapped(Biome.RainType precipitation, float temperature, Biome.TemperatureModifier temperatureModifier, float downfall) {
            this.precipitation = precipitation;
            this.temperature = temperature;
            this.temperatureModifier = temperatureModifier;
            this.downfall = downfall;
        }

        @Override
        @NotNull
        public Biome.RainType getPrecipitation() {
            return this.precipitation;
        }

        @Override
        public float getTemperature() {
            return this.temperature;
        }

        @Override
        @NotNull
        public Biome.TemperatureModifier getTemperatureModifier() {
            return this.temperatureModifier;
        }

        @Override
        public float getDownfall() {
            return this.downfall;
        }

        @Override
        @NotNull
        public ClimateProperties.Mutable setPrecipitation(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull Biome.RainType precipitation) {
            this.precipitation = precipitation;
            this.dirty = true;
            return this;
        }

        @Override
        @NotNull
        public ClimateProperties.Mutable setTemperature(float temperature) {
            this.temperature = temperature;
            this.dirty = true;
            return this;
        }

        @Override
        @NotNull
        public ClimateProperties.Mutable setTemperatureModifier(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull Biome.TemperatureModifier temperatureModifier) {
            this.temperatureModifier = temperatureModifier;
            this.dirty = true;
            return this;
        }

        @Override
        @NotNull
        public ClimateProperties.Mutable setDownfall(float downfall) {
            this.downfall = downfall;
            this.dirty = true;
            return this;
        }
    }

    public static class MutableBiomeWrapped
    extends BiomeWrapped
    implements BiomeProperties.Mutable {
        public MutableBiomeWrapped(BiomeLoadingEvent event) {
            super(event, new MutableClimatePropertiesWrapped(event.getClimate()), new BiomeHooks.EffectsWrapped(event.getEffects()), new MutableGenerationSettingsBuilderWrapped(event.getGeneration()), new MutableSpawnSettingsBuilderWrapped(event.getSpawns()));
        }

        @Override
        @NotNull
        public ClimateProperties.Mutable getClimateProperties() {
            return (ClimateProperties.Mutable)super.getClimateProperties();
        }

        @Override
        @NotNull
        public EffectsProperties.Mutable getEffectsProperties() {
            return (EffectsProperties.Mutable)super.getEffectsProperties();
        }

        @Override
        @NotNull
        public GenerationProperties.Mutable getGenerationProperties() {
            return (GenerationProperties.Mutable)super.getGenerationProperties();
        }

        @Override
        @NotNull
        public SpawnProperties.Mutable getSpawnProperties() {
            return (SpawnProperties.Mutable)super.getSpawnProperties();
        }

        @Override
        @NotNull
        public BiomeProperties.Mutable setCategory(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull Biome.Category category) {
            this.event.setCategory(category);
            return this;
        }

        @Override
        @NotNull
        public BiomeProperties.Mutable setDepth(float depth) {
            this.event.setDepth(depth);
            return this;
        }

        @Override
        @NotNull
        public BiomeProperties.Mutable setScale(float scale) {
            this.event.setScale(scale);
            return this;
        }
    }

    private static class SpawnSettingsBuilderWrapped
    implements SpawnProperties {
        protected final MobSpawnInfoBuilder builder;

        public SpawnSettingsBuilderWrapped(MobSpawnInfoBuilder builder) {
            this.builder = builder;
        }

        @Override
        public float getCreatureProbability() {
            return this.builder.getProbability();
        }

        @Override
        @NotNull
        public Map<EntityClassification, List<MobSpawnInfo.Spawners>> getSpawners() {
            return ((MobSpawnSettingsBuilderAccessor)this.builder).getSpawners();
        }

        @Override
        @NotNull
        public Map<EntityType<?>, MobSpawnInfo.SpawnCosts> getMobSpawnCosts() {
            return ((MobSpawnSettingsBuilderAccessor)this.builder).getMobSpawnCosts();
        }

        @Override
        public boolean isPlayerSpawnFriendly() {
            return ((MobSpawnSettingsBuilderAccessor)this.builder).isPlayerCanSpawn();
        }
    }

    private static class GenerationSettingsBuilderWrapped
    implements GenerationProperties {
        protected final BiomeGenerationSettingsBuilder generation;

        public GenerationSettingsBuilderWrapped(BiomeGenerationSettingsBuilder generation) {
            this.generation = generation;
        }

        @Override
        @NotNull
        public Optional<Supplier<ConfiguredSurfaceBuilder<?>>> getSurfaceBuilder() {
            return this.generation.getSurfaceBuilder();
        }

        @Override
        @NotNull
        public List<Supplier<ConfiguredCarver<?>>> getCarvers(GenerationStage.Carving carving) {
            return this.generation.getCarvers(carving);
        }

        @Override
        @NotNull
        public List<List<Supplier<ConfiguredFeature<?, ?>>>> getFeatures() {
            return ((BiomeGenerationSettingsBuilderAccessor)this.generation).getFeatures();
        }

        @Override
        @NotNull
        public List<Supplier<StructureFeature<?, ?>>> getStructureStarts() {
            return this.generation.getStructures();
        }
    }

    public static class BiomeWrapped
    implements BiomeProperties {
        protected final BiomeLoadingEvent event;
        protected final ClimateProperties climateProperties;
        protected final EffectsProperties effectsProperties;
        protected final GenerationProperties generationProperties;
        protected final SpawnProperties spawnProperties;

        public BiomeWrapped(BiomeLoadingEvent event) {
            this(event, new BiomeHooks.ClimateWrapped(event.getClimate()), new BiomeHooks.EffectsWrapped(event.getEffects()), new GenerationSettingsBuilderWrapped(event.getGeneration()), new SpawnSettingsBuilderWrapped(event.getSpawns()));
        }

        public BiomeWrapped(BiomeLoadingEvent event, ClimateProperties climateProperties, EffectsProperties effectsProperties, GenerationProperties generationProperties, SpawnProperties spawnProperties) {
            this.event = event;
            this.climateProperties = climateProperties;
            this.effectsProperties = effectsProperties;
            this.generationProperties = generationProperties;
            this.spawnProperties = spawnProperties;
        }

        @Override
        @NotNull
        public ClimateProperties getClimateProperties() {
            return this.climateProperties;
        }

        @Override
        @NotNull
        public EffectsProperties getEffectsProperties() {
            return this.effectsProperties;
        }

        @Override
        @NotNull
        public GenerationProperties getGenerationProperties() {
            return this.generationProperties;
        }

        @Override
        @NotNull
        public SpawnProperties getSpawnProperties() {
            return this.spawnProperties;
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull Biome.Category getCategory() {
            return this.event.getCategory();
        }

        @Override
        public float getDepth() {
            return this.event.getDepth();
        }

        @Override
        public float getScale() {
            return this.event.getScale();
        }
    }
}

