/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.registry;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RegistrySupplier<T>
extends Supplier<T> {
    @NotNull
    public ResourceLocation getRegistryId();

    @NotNull
    public ResourceLocation getId();

    public boolean isPresent();

    @Nullable
    default public T getOrNull() {
        if (this.isPresent()) {
            return this.get();
        }
        return null;
    }

    @NotNull
    default public Optional<T> toOptional() {
        return Optional.ofNullable(this.getOrNull());
    }

    default public void ifPresent(Consumer<? super T> action) {
        if (this.isPresent()) {
            action.accept(this.get());
        }
    }

    default public void ifPresentOrElse(Consumer<? super T> action, Runnable emptyAction) {
        if (this.isPresent()) {
            action.accept(this.get());
        } else {
            emptyAction.run();
        }
    }

    @NotNull
    default public Stream<T> stream() {
        if (!this.isPresent()) {
            return Stream.empty();
        }
        return Stream.of(this.get());
    }

    default public T orElse(T other) {
        return this.isPresent() ? this.get() : other;
    }

    default public T orElseGet(Supplier<? extends T> supplier) {
        return this.isPresent() ? this.get() : supplier.get();
    }
}

