/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.registry;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import me.shedaniel.architectury.registry.Registries;
import me.shedaniel.architectury.registry.Registry;
import me.shedaniel.architectury.registry.RegistrySupplier;
import net.minecraft.util.LazyValue;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeferredRegister<T> {
    @NotNull
    private final Supplier<Registries> registriesSupplier;
    @NotNull
    private final RegistryKey<net.minecraft.util.registry.Registry<T>> key;
    private final List<Entry<T>> entries = new ArrayList<Entry<T>>();
    private boolean registered = false;
    @Nullable
    private String modId;

    private DeferredRegister(@NotNull Supplier<Registries> registriesSupplier, @NotNull RegistryKey<net.minecraft.util.registry.Registry<T>> key, @Nullable String modId) {
        this.registriesSupplier = Objects.requireNonNull(registriesSupplier);
        this.key = Objects.requireNonNull(key);
        this.modId = modId;
    }

    @NotNull
    public static <T> DeferredRegister<T> create(@NotNull String modId, @NotNull RegistryKey<net.minecraft.util.registry.Registry<T>> key) {
        LazyValue value = new LazyValue(() -> Registries.get(modId));
        return new DeferredRegister<T>(() -> ((LazyValue)value).func_179281_c(), key, Objects.requireNonNull(modId));
    }

    @Deprecated
    @NotNull
    public static <T> DeferredRegister<T> create(@NotNull Registries registries, @NotNull RegistryKey<net.minecraft.util.registry.Registry<T>> key) {
        return new DeferredRegister<T>(() -> registries, key, null);
    }

    @Deprecated
    @NotNull
    public static <T> DeferredRegister<T> create(@NotNull Supplier<Registries> registries, @NotNull RegistryKey<net.minecraft.util.registry.Registry<T>> key) {
        return new DeferredRegister<T>(registries, key, null);
    }

    @Deprecated
    @NotNull
    public static <T> DeferredRegister<T> create(@NotNull LazyValue<Registries> registries, @NotNull RegistryKey<net.minecraft.util.registry.Registry<T>> key) {
        return DeferredRegister.create(() -> registries.func_179281_c(), key);
    }

    public <R extends T> RegistrySupplier<R> register(String id, Supplier<? extends R> supplier) {
        if (this.modId == null) {
            throw new NullPointerException("You must create the deferred register with a mod id to register entries without the namespace!");
        }
        return this.register(new ResourceLocation(this.modId, id), supplier);
    }

    public <R extends T> RegistrySupplier<R> register(ResourceLocation id, Supplier<? extends R> supplier) {
        Entry<? extends R> entry = new Entry<R>(id, supplier);
        this.entries.add(entry);
        if (this.registered) {
            Registry<T> registry = this.registriesSupplier.get().get(this.key);
            ((Entry)entry).value = registry.registerSupplied(((Entry)entry).id, ((Entry)entry).supplier);
        }
        return entry;
    }

    public void register() {
        if (this.registered) {
            throw new IllegalStateException("Cannot register a deferred register twice!");
        }
        this.registered = true;
        Registry<T> registry = this.registriesSupplier.get().get(this.key);
        for (Entry<T> entry : this.entries) {
            ((Entry)entry).value = registry.registerSupplied(((Entry)entry).id, ((Entry)entry).supplier);
        }
    }

    private class Entry<R>
    implements RegistrySupplier<R> {
        private final ResourceLocation id;
        private final Supplier<R> supplier;
        private RegistrySupplier<R> value;

        public Entry(ResourceLocation id, Supplier<R> supplier) {
            this.id = id;
            this.supplier = supplier;
        }

        @Override
        @NotNull
        public ResourceLocation getRegistryId() {
            return DeferredRegister.this.key.func_240901_a_();
        }

        @Override
        @NotNull
        public ResourceLocation getId() {
            return this.id;
        }

        @Override
        public boolean isPresent() {
            return this.value != null && this.value.isPresent();
        }

        @Override
        public R get() {
            if (this.isPresent()) {
                return (R)this.value.get();
            }
            throw new NullPointerException("Registry Object not present: " + this.id);
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.getRegistryId(), this.getId()});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof RegistrySupplier)) {
                return false;
            }
            RegistrySupplier other = (RegistrySupplier)obj;
            return other.getRegistryId().equals((Object)this.getRegistryId()) && other.getId().equals((Object)this.getId());
        }

        public String toString() {
            return this.getRegistryId().toString() + "@" + this.id.toString();
        }
    }
}

