/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.networking.forge;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import me.shedaniel.architectury.networking.NetworkManager;
import me.shedaniel.architectury.networking.forge.ClientNetworkingManager;
import me.shedaniel.architectury.utils.Env;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.event.EventNetworkChannel;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="architectury")
public class NetworkManagerImpl {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation CHANNEL_ID = new ResourceLocation("architectury:network");
    static final ResourceLocation SYNC_IDS = new ResourceLocation("architectury:sync_ids");
    static final EventNetworkChannel CHANNEL = NetworkRegistry.newEventChannel((ResourceLocation)CHANNEL_ID, () -> "1", version -> true, version -> true);
    static final Map<ResourceLocation, NetworkManager.NetworkReceiver> S2C = Maps.newHashMap();
    static final Map<ResourceLocation, NetworkManager.NetworkReceiver> C2S = Maps.newHashMap();
    static final Set<ResourceLocation> serverReceivables = Sets.newHashSet();
    private static final Multimap<PlayerEntity, ResourceLocation> clientReceivables = Multimaps.newMultimap((Map)Maps.newHashMap(), Sets::newHashSet);

    public static void registerReceiver(NetworkManager.Side side, ResourceLocation id, NetworkManager.NetworkReceiver receiver) {
        if (side == NetworkManager.Side.C2S) {
            NetworkManagerImpl.registerC2SReceiver(id, receiver);
        } else if (side == NetworkManager.Side.S2C) {
            NetworkManagerImpl.registerS2CReceiver(id, receiver);
        }
    }

    public static IPacket<?> toPacket(NetworkManager.Side side, ResourceLocation id, PacketBuffer buffer) {
        PacketBuffer packetBuffer = new PacketBuffer(Unpooled.buffer());
        packetBuffer.func_192572_a(id);
        packetBuffer.writeBytes((ByteBuf)buffer);
        return (side == NetworkManager.Side.C2S ? NetworkDirection.PLAY_TO_SERVER : NetworkDirection.PLAY_TO_CLIENT).buildPacket(Pair.of((Object)packetBuffer, (Object)0), CHANNEL_ID).getThis();
    }

    static <T extends NetworkEvent> Consumer<T> createPacketHandler(Class<T> clazz, Map<ResourceLocation, NetworkManager.NetworkReceiver> map) {
        return event -> {
            if (event.getClass() != clazz) {
                return;
            }
            final NetworkEvent.Context context = (NetworkEvent.Context)event.getSource().get();
            if (context.getPacketHandled()) {
                return;
            }
            PacketBuffer buffer = event.getPayload();
            if (buffer == null) {
                return;
            }
            ResourceLocation type = buffer.func_192575_l();
            NetworkManager.NetworkReceiver receiver = (NetworkManager.NetworkReceiver)map.get(type);
            if (receiver != null) {
                receiver.receive(buffer, new NetworkManager.PacketContext(){

                    @Override
                    public PlayerEntity getPlayer() {
                        return this.getEnvironment() == Env.CLIENT ? this.getClientPlayer() : context.getSender();
                    }

                    @Override
                    public void queue(Runnable runnable) {
                        context.enqueueWork(runnable);
                    }

                    @Override
                    public Env getEnvironment() {
                        return context.getDirection().getReceptionSide() == LogicalSide.CLIENT ? Env.CLIENT : Env.SERVER;
                    }

                    private PlayerEntity getClientPlayer() {
                        return (PlayerEntity)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> ClientNetworkingManager::getClientPlayer);
                    }
                });
            } else {
                LOGGER.error("Unknown message ID: " + type);
            }
            context.setPacketHandled(true);
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerS2CReceiver(ResourceLocation id, NetworkManager.NetworkReceiver receiver) {
        S2C.put(id, receiver);
    }

    public static void registerC2SReceiver(ResourceLocation id, NetworkManager.NetworkReceiver receiver) {
        C2S.put(id, receiver);
    }

    public static boolean canServerReceive(ResourceLocation id) {
        return serverReceivables.contains(id);
    }

    public static boolean canPlayerReceive(ServerPlayerEntity player, ResourceLocation id) {
        return clientReceivables.get((Object)player).contains(id);
    }

    static PacketBuffer sendSyncPacket(Map<ResourceLocation, NetworkManager.NetworkReceiver> map) {
        ArrayList availableIds = Lists.newArrayList(map.keySet());
        PacketBuffer packetBuffer = new PacketBuffer(Unpooled.buffer());
        packetBuffer.writeInt(availableIds.size());
        for (ResourceLocation availableId : availableIds) {
            packetBuffer.func_192572_a(availableId);
        }
        return packetBuffer;
    }

    @SubscribeEvent
    public static void loggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        NetworkManager.sendToPlayer((ServerPlayerEntity)event.getPlayer(), SYNC_IDS, NetworkManagerImpl.sendSyncPacket(C2S));
    }

    @SubscribeEvent
    public static void loggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        clientReceivables.removeAll((Object)event.getPlayer());
    }

    static {
        CHANNEL.addListener(NetworkManagerImpl.createPacketHandler(NetworkEvent.ClientCustomPayloadEvent.class, C2S));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ClientNetworkingManager::initClient);
        NetworkManagerImpl.registerC2SReceiver(SYNC_IDS, (buffer, context) -> {
            Set receivables = (Set)clientReceivables.get((Object)context.getPlayer());
            int size = buffer.readInt();
            receivables.clear();
            for (int i = 0; i < size; ++i) {
                receivables.add(buffer.func_192575_l());
            }
        });
    }
}

