/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.event.forge;

import java.util.function.Consumer;
import me.shedaniel.architectury.event.Actor;
import me.shedaniel.architectury.event.Event;
import net.minecraft.util.ActionResultType;
import net.minecraftforge.common.MinecraftForge;

public class EventFactoryImpl {
    public static <T> Event<Consumer<T>> attachToForge(Event<Consumer<T>> event) {
        event.register(eventObj -> {
            if (!(eventObj instanceof net.minecraftforge.eventbus.api.Event)) {
                throw new ClassCastException(eventObj.getClass() + " is not an instance of forge Event!");
            }
            MinecraftForge.EVENT_BUS.post((net.minecraftforge.eventbus.api.Event)eventObj);
        });
        return event;
    }

    public static <T> Event<Actor<T>> attachToForgeActor(Event<Actor<T>> event) {
        event.register(eventObj -> {
            if (!(eventObj instanceof net.minecraftforge.eventbus.api.Event)) {
                throw new ClassCastException(eventObj.getClass() + " is not an instance of forge Event!");
            }
            MinecraftForge.EVENT_BUS.post((net.minecraftforge.eventbus.api.Event)eventObj);
            return ActionResultType.PASS;
        });
        return event;
    }

    public static <T> Event<Actor<T>> attachToForgeActorCancellable(Event<Actor<T>> event) {
        event.register(eventObj -> {
            if (!(eventObj instanceof net.minecraftforge.eventbus.api.Event)) {
                throw new ClassCastException(eventObj.getClass() + " is not an instance of forge Event!");
            }
            if (!((net.minecraftforge.eventbus.api.Event)eventObj).isCancelable()) {
                throw new ClassCastException(eventObj.getClass() + " is not cancellable Event!");
            }
            if (MinecraftForge.EVENT_BUS.post((net.minecraftforge.eventbus.api.Event)eventObj)) {
                return ActionResultType.FAIL;
            }
            return ActionResultType.PASS;
        });
        return event;
    }
}

